/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.resolver;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.policy.infoset.PolicyEvaluator;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.domain.generator.policy.PolicyRegistry;
import org.fabric3.spi.domain.generator.policy.PolicyResolutionException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;

public class AbstractPolicyResolver {
    protected LogicalComponentManager lcm;
    protected PolicyEvaluator policyEvaluator;
    protected PolicyRegistry policyRegistry;

    protected AbstractPolicyResolver(PolicyRegistry policyRegistry, LogicalComponentManager lcm, PolicyEvaluator policyEvaluator) {
        this.policyRegistry = policyRegistry;
        this.lcm = lcm;
        this.policyEvaluator = policyEvaluator;
    }

    protected Set<PolicySet> resolvePolicies(Set<Intent> intents, LogicalScaArtifact<?> target) throws PolicyResolutionException {
        LinkedHashSet<PolicySet> policies = new LinkedHashSet<PolicySet>();
        Collection definitions = this.policyRegistry.getAllDefinitions(PolicySet.class);
        for (PolicySet policySet : definitions) {
            Iterator<Intent> iterator = intents.iterator();
            while (iterator.hasNext()) {
                Intent intent = iterator.next();
                if (!policySet.doesProvide(intent.getName())) continue;
                String appliesTo = policySet.getAppliesTo();
                String attachTo = policySet.getAttachTo();
                if (!(appliesTo == null && attachTo == null || attachTo == null && this.policyEvaluator.doesApply(appliesTo, target)) && attachTo == null) continue;
                policies.add(policySet);
                iterator.remove();
            }
        }
        return policies;
    }

    protected void filterInvalidIntents(QName type, Set<Intent> requiredIntents) throws PolicyResolutionException {
        Iterator<Intent> it = requiredIntents.iterator();
        while (it.hasNext()) {
            Intent intent = it.next();
            QName intentName = intent.getName();
            if (intent.getIntentType() != null) {
                if (intent.doesConstrain(type)) continue;
                it.remove();
                continue;
            }
            if (!intent.isQualified()) {
                throw new PolicyResolutionException("Unqualified intent without constrained artifact: " + intentName);
            }
            Intent qualifiableIntent = (Intent)this.policyRegistry.getDefinition(intent.getQualifiable(), Intent.class);
            if (qualifiableIntent == null) {
                throw new PolicyResolutionException("Unknown intent: " + intent.getQualifiable());
            }
            if (qualifiableIntent.doesConstrain(type)) continue;
            it.remove();
        }
    }

    protected void filterMutuallyExclusiveIntents(Set<Intent> intents) {
        if (intents.isEmpty()) {
            return;
        }
        HashSet<Intent> removed = new HashSet<Intent>();
        for (Intent current : intents) {
            if (removed.contains(current)) continue;
            for (Intent intent : intents) {
                if (!current.getExcludes().contains(intent.getName()) && !intent.getExcludes().contains(current.getName())) continue;
                removed.add(intent);
            }
        }
        for (Intent intent : removed) {
            intents.remove(intent);
        }
    }

    protected Set<QName> aggregateIntents(LogicalBinding<?> binding) throws PolicyResolutionException {
        Bindable parent = (Bindable)binding.getParent();
        LinkedHashSet<QName> aggregatedIntents = new LinkedHashSet<QName>();
        aggregatedIntents.addAll(binding.getIntents());
        this.validateIntents(binding);
        if (parent instanceof LogicalReference) {
            return this.aggregateReferenceIntents((LogicalReference)parent, aggregatedIntents);
        }
        if (parent instanceof LogicalService) {
            return this.aggregateServiceIntents((LogicalService)parent, aggregatedIntents);
        }
        LogicalChannel channel = (LogicalChannel)parent;
        aggregatedIntents.addAll(channel.getDefinition().getIntents());
        aggregatedIntents.addAll(channel.getIntents());
        return aggregatedIntents;
    }

    private void validateIntents(LogicalBinding<?> binding) throws PolicyResolutionException {
        Set intents = this.policyRegistry.getDefinitions(binding.getIntents(), Intent.class);
        for (Intent current : intents) {
            for (Intent intent : intents) {
                if (!current.getExcludes().contains(intent.getName())) continue;
                throw new PolicyResolutionException("Mutually exclusive intents specified on binding: " + ((Bindable)binding.getParent()).getUri());
            }
        }
    }

    private Set<QName> aggregateServiceIntents(LogicalService service, Set<QName> aggregatedIntents) {
        this.processIntents(service.getIntents(), aggregatedIntents);
        LogicalService currentService = service;
        for (LogicalComponent parent = (LogicalComponent)service.getParent(); parent != null; parent = (LogicalComponent)parent.getParent()) {
            this.processIntents(parent.getIntents(), aggregatedIntents);
            ComponentDefinition definition = parent.getDefinition();
            if (definition != null) {
                this.processIntents(definition.getIntents(), aggregatedIntents);
                Implementation implementation = definition.getImplementation();
                if (implementation != null) {
                    this.processIntents(implementation.getIntents(), aggregatedIntents);
                    ComponentType componentType = implementation.getComponentType();
                    if (componentType != null) {
                        this.processIntents(componentType.getIntents(), aggregatedIntents);
                    }
                }
            }
            if (parent.getParent() != null && ((LogicalCompositeComponent)parent.getParent()).getParent() == null) {
                ComponentDefinition componentDefinition = parent.getDefinition();
                ComponentType type = (ComponentType)componentDefinition.getParent();
                this.processIntents(type.getIntents(), aggregatedIntents);
            }
            if (!(parent instanceof LogicalCompositeComponent)) continue;
            LogicalCompositeComponent compositeParent = (LogicalCompositeComponent)parent;
            for (LogicalService logicalService : compositeParent.getServices()) {
                if (!logicalService.getPromotedUri().equals(currentService.getUri())) continue;
                this.processIntents(logicalService.getIntents(), aggregatedIntents);
                currentService = logicalService;
            }
        }
        return aggregatedIntents;
    }

    private Set<QName> aggregateReferenceIntents(LogicalReference reference, Set<QName> aggregatedIntents) {
        this.processIntents(reference.getIntents(), aggregatedIntents);
        LogicalReference currentReference = reference;
        for (LogicalComponent parent = (LogicalComponent)reference.getParent(); parent != null; parent = (LogicalComponent)parent.getParent()) {
            this.processIntents(parent.getIntents(), aggregatedIntents);
            ComponentDefinition definition = parent.getDefinition();
            if (definition != null) {
                this.processIntents(definition.getIntents(), aggregatedIntents);
                Implementation implementation = definition.getImplementation();
                if (implementation != null) {
                    this.processIntents(implementation.getIntents(), aggregatedIntents);
                    ComponentType componentType = implementation.getComponentType();
                    if (componentType != null) {
                        this.processIntents(componentType.getIntents(), aggregatedIntents);
                    }
                }
            }
            if (parent.getParent() != null && ((LogicalCompositeComponent)parent.getParent()).getParent() == null) {
                ComponentDefinition componentDefinition = parent.getDefinition();
                ComponentType type = (ComponentType)componentDefinition.getParent();
                this.processIntents(type.getIntents(), aggregatedIntents);
            }
            if (!(parent instanceof LogicalCompositeComponent)) continue;
            LogicalCompositeComponent compositeParent = (LogicalCompositeComponent)parent;
            for (LogicalReference logicalReference : compositeParent.getReferences()) {
                for (URI promotedUri : logicalReference.getPromotedUris()) {
                    if (!promotedUri.equals(currentReference.getUri())) continue;
                    this.processIntents(logicalReference.getIntents(), aggregatedIntents);
                    currentReference = logicalReference;
                }
            }
        }
        return aggregatedIntents;
    }

    protected Set<QName> aggregateIntents(LogicalComponent<?> component) {
        LinkedHashSet<QName> aggregatedIntents = new LinkedHashSet<QName>();
        for (LogicalComponent current = component; current != null; current = (LogicalComponent)current.getParent()) {
            Set currentIntents = current.getIntents();
            this.processIntents(currentIntents, aggregatedIntents);
            ComponentDefinition definition = current.getDefinition();
            if (definition == null) continue;
            this.processIntents(definition.getIntents(), aggregatedIntents);
            Implementation implementation = definition.getImplementation();
            if (implementation == null) continue;
            this.processIntents(implementation.getIntents(), aggregatedIntents);
            ComponentType componentType = implementation.getComponentType();
            if (componentType == null) continue;
            this.processIntents(componentType.getIntents(), aggregatedIntents);
        }
        return aggregatedIntents;
    }

    private void processIntents(Set<QName> intents, Set<QName> aggregatedIntents) {
        for (QName currentIntent : intents) {
            String localPart = currentIntent.getLocalPart();
            boolean exclude = false;
            String namespace = currentIntent.getNamespaceURI();
            Iterator<QName> iterator = aggregatedIntents.iterator();
            while (iterator.hasNext()) {
                QName aggregatedIntent = iterator.next();
                if (namespace.equals(aggregatedIntent.getNamespaceURI()) && aggregatedIntent.getLocalPart().startsWith(localPart + ".")) {
                    exclude = true;
                    break;
                }
                if (!namespace.equals(aggregatedIntent.getNamespaceURI()) || !localPart.startsWith(aggregatedIntent.getLocalPart() + ".")) continue;
                iterator.remove();
                break;
            }
            if (exclude) continue;
            aggregatedIntents.add(currentIntent);
        }
    }

    protected Set<Intent> resolveIntents(Set<QName> intentNames) throws PolicyResolutionException {
        LinkedHashSet<Intent> requiredIntents = new LinkedHashSet<Intent>();
        for (QName intentName : intentNames) {
            Intent intent = (Intent)this.policyRegistry.getDefinition(intentName, Intent.class);
            if (intent == null) {
                throw new PolicyResolutionException("Unknown intent: " + intentName);
            }
            if (intent.isProfile()) {
                for (QName requiredIntentName : intent.getRequires()) {
                    Intent requiredIntent = (Intent)this.policyRegistry.getDefinition(requiredIntentName, Intent.class);
                    if (requiredIntent == null) {
                        throw new PolicyResolutionException("Unknown intent" + requiredIntentName);
                    }
                    requiredIntents.add(requiredIntent);
                }
                continue;
            }
            requiredIntents.add(intent);
        }
        return requiredIntents;
    }
}

