/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.interceptor.simple;

import java.net.URI;
import org.fabric3.policy.interceptor.simple.SimpleInterceptorBuilderException;
import org.fabric3.policy.interceptor.simple.SimpleInterceptorDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.interceptor.InterceptorBuilder;
import org.fabric3.spi.container.wire.Interceptor;
import org.oasisopen.sca.annotation.Reference;

public class SimpleInterceptorBuilder
implements InterceptorBuilder<SimpleInterceptorDefinition> {
    private ClassLoaderRegistry registry;

    public SimpleInterceptorBuilder(@Reference ClassLoaderRegistry registry) {
        this.registry = registry;
    }

    public Interceptor build(SimpleInterceptorDefinition definition) throws ContainerException {
        String className = definition.getInterceptorClass();
        URI classLoaderUri = definition.getPolicyClassLoaderId();
        ClassLoader loader = this.registry.getClassLoader(classLoaderUri);
        if (loader == null) {
            throw new SimpleInterceptorBuilderException("Interceptor classloader not found: " + classLoaderUri);
        }
        try {
            Class<?> interceptorClass = loader.loadClass(className);
            return (Interceptor)interceptorClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SimpleInterceptorBuilderException("Unable load class: " + className, e);
        }
    }
}

