/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.model.instance.LogicalOperation;

public class EffectivePolicyImpl
implements EffectivePolicy {
    private Set<Intent> providedEndpointIntents = new HashSet<Intent>();
    private Set<Intent> aggregatedEndpointIntents = new HashSet<Intent>();
    private Set<PolicySet> endpointPolicySets = new HashSet<PolicySet>();
    private Map<LogicalOperation, List<Intent>> providedIntentMap = new HashMap<LogicalOperation, List<Intent>>();
    private Map<LogicalOperation, List<PolicySet>> policySetMap = new HashMap<LogicalOperation, List<PolicySet>>();

    public Set<Intent> getProvidedEndpointIntents() {
        return this.providedEndpointIntents;
    }

    public Set<Intent> getAggregatedEndpointIntents() {
        return this.aggregatedEndpointIntents;
    }

    public Set<PolicySet> getEndpointPolicySets() {
        return this.endpointPolicySets;
    }

    public List<Intent> getOperationIntents() {
        ArrayList<Intent> ret = new ArrayList<Intent>();
        for (LogicalOperation operation : this.providedIntentMap.keySet()) {
            ret.addAll(this.getIntents(operation));
        }
        return ret;
    }

    public Map<LogicalOperation, List<PolicySet>> getOperationPolicySets() {
        return this.policySetMap;
    }

    public List<Intent> getIntents(LogicalOperation operation) {
        return this.providedIntentMap.get(operation);
    }

    public List<PolicySet> getPolicySets(LogicalOperation operation) {
        return this.policySetMap.get(operation);
    }

    void addProvidedEndpointIntents(Set<Intent> intents) {
        this.providedEndpointIntents.addAll(intents);
    }

    void addAggregatedEndpointIntents(Set<Intent> intents) {
        this.aggregatedEndpointIntents.addAll(intents);
    }

    void addEndpointPolicySets(Set<PolicySet> policySets) {
        this.endpointPolicySets.addAll(policySets);
    }

    void addProvidedIntents(LogicalOperation operation, Set<Intent> intents) {
        if (!this.providedIntentMap.containsKey(operation)) {
            this.providedIntentMap.put(operation, new ArrayList());
        }
        this.providedIntentMap.get(operation).addAll(intents);
    }

    void addPolicySets(LogicalOperation operation, Set<PolicySet> policySets) {
        if (!this.policySetMap.containsKey(operation)) {
            this.policySetMap.put(operation, new ArrayList());
        }
        this.policySetMap.get(operation).addAll(policySets);
    }
}

