/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.PolicyPhase;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.policy.NullPolicyResult;
import org.fabric3.policy.PolicyResultImpl;
import org.fabric3.policy.resolver.ImplementationPolicyResolver;
import org.fabric3.policy.resolver.IntentPair;
import org.fabric3.policy.resolver.InteractionPolicyResolver;
import org.fabric3.spi.contract.OperationNotFoundException;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.domain.generator.policy.PolicyMetadata;
import org.fabric3.spi.domain.generator.policy.PolicyResolutionException;
import org.fabric3.spi.domain.generator.policy.PolicyResolver;
import org.fabric3.spi.domain.generator.policy.PolicyResult;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.binding.LocalBindingDefinition;
import org.fabric3.spi.model.type.binding.RemoteBindingDefinition;
import org.fabric3.spi.model.type.remote.RemoteImplementation;
import org.fabric3.util.closure.Closure;
import org.fabric3.util.closure.CollectionUtils;
import org.oasisopen.sca.annotation.Reference;

public class DefaultPolicyResolver
implements PolicyResolver {
    private static final QName IMPLEMENTATION_SYSTEM = new QName("urn:fabric3.org", "implementation.system");
    private static final QName IMPLEMENTATION_SINGLETON = new QName("urn:fabric3.org", "singleton");
    private static final PolicyResult EMPTY_RESULT = new NullPolicyResult();
    private static final Operation DEFINITION = new Operation("_fabric3Generated", null, null, null);
    private static final Closure<PolicySet, Boolean> INTERCEPTION = new Closure<PolicySet, Boolean>(){

        public Boolean execute(PolicySet policySet) {
            return policySet.getPhase() == PolicyPhase.INTERCEPTION;
        }
    };
    private static final Closure<PolicySet, Boolean> PROVIDED = new Closure<PolicySet, Boolean>(){

        public Boolean execute(PolicySet policySet) {
            return policySet.getPhase() == PolicyPhase.PROVIDED;
        }
    };
    private InteractionPolicyResolver interactionResolver;
    private ImplementationPolicyResolver implementationResolver;
    private OperationResolver operationResolver;

    public DefaultPolicyResolver(@Reference InteractionPolicyResolver interactionResolver, @Reference ImplementationPolicyResolver implementationResolver, @Reference OperationResolver operationResolver) {
        this.interactionResolver = interactionResolver;
        this.implementationResolver = implementationResolver;
        this.operationResolver = operationResolver;
    }

    public PolicyResult resolvePolicies(LogicalBinding<?> binding) throws PolicyResolutionException {
        Bindable parent = (Bindable)binding.getParent();
        LogicalBinding remoteBinding = new LogicalBinding((BindingDefinition)RemoteBindingDefinition.INSTANCE, parent);
        Bindable bindable = (Bindable)binding.getParent();
        if (bindable instanceof LogicalReference) {
            return this.resolvePolicies(bindable.getOperations(), remoteBinding, binding, (LogicalComponent)bindable.getParent(), null);
        }
        if (bindable instanceof LogicalService) {
            return this.resolvePolicies(bindable.getOperations(), binding, remoteBinding, null, (LogicalComponent)bindable.getParent());
        }
        throw new UnsupportedOperationException();
    }

    public PolicyResult resolveCallbackPolicies(LogicalBinding<?> binding) throws PolicyResolutionException {
        LogicalBinding remoteBinding = new LogicalBinding((BindingDefinition)RemoteBindingDefinition.INSTANCE, (Bindable)binding.getParent());
        Bindable bindable = (Bindable)binding.getParent();
        if (bindable instanceof LogicalReference) {
            return this.resolvePolicies(bindable.getCallbackOperations(), remoteBinding, binding, (LogicalComponent)bindable.getParent(), null);
        }
        if (bindable instanceof LogicalService) {
            return this.resolvePolicies(bindable.getCallbackOperations(), remoteBinding, binding, (LogicalComponent)bindable.getParent(), null);
        }
        throw new IllegalArgumentException("Only services and references can have callback operations");
    }

    public PolicyResult resolveLocalPolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget().getLeafService();
        LogicalComponent source = (LogicalComponent)reference.getParent();
        LogicalComponent target = service.getLeafComponent();
        LogicalBinding sourceBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)reference);
        LogicalBinding targetBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)service);
        return this.resolvePolicies(reference.getOperations(), sourceBinding, targetBinding, source, target);
    }

    public PolicyResult resolveLocalCallbackPolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent targetComponent = (LogicalComponent)reference.getParent();
        ServiceContract referenceCallbackContract = reference.getServiceContract().getCallbackContract();
        LogicalService callbackService = targetComponent.getService(referenceCallbackContract.getInterfaceName());
        LogicalBinding sourceBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)callbackService);
        LogicalBinding targetBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)reference);
        LogicalComponent sourceComponent = service.getLeafComponent();
        return this.resolvePolicies(service.getCallbackOperations(), sourceBinding, targetBinding, sourceComponent, targetComponent);
    }

    public PolicyResult resolveRemotePolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent source = (LogicalComponent)reference.getParent();
        LogicalComponent target = service.getLeafComponent();
        LogicalBinding serviceBinding = wire.getTargetBinding();
        List sourceOperations = reference.getOperations();
        return this.resolvePolicies(sourceOperations, serviceBinding, serviceBinding, source, target);
    }

    public PolicyResult resolveRemoteCallbackPolicies(LogicalWire wire) throws PolicyResolutionException {
        LogicalReference reference = wire.getSource();
        LogicalComponent target = (LogicalComponent)reference.getParent();
        ServiceContract referenceContract = reference.getServiceContract();
        ServiceContract referenceCallbackContract = referenceContract.getCallbackContract();
        LogicalBinding referenceBinding = (LogicalBinding)reference.getCallbackBindings().get(0);
        LogicalService callbackService = target.getService(referenceCallbackContract.getInterfaceName());
        List operations = reference.getCallbackOperations();
        LogicalBinding sourceBinding = new LogicalBinding((BindingDefinition)LocalBindingDefinition.INSTANCE, (Bindable)callbackService);
        return this.resolvePolicies(operations, sourceBinding, referenceBinding, null, target);
    }

    public PolicyResult resolvePolicies(LogicalConsumer consumer) throws PolicyResolutionException {
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        if (this.noPolicy(component)) {
            return EMPTY_RESULT;
        }
        PolicyResultImpl policyResult = new PolicyResultImpl();
        LogicalOperation operation = new LogicalOperation(DEFINITION, (LogicalAttachPoint)consumer);
        IntentPair targetOperationIntentPair = this.interactionResolver.resolveIntents(operation, LocalBindingDefinition.INSTANCE.getType());
        policyResult.addTargetProvidedIntents(operation, targetOperationIntentPair.getProvidedIntents());
        IntentPair sourceImplementationIntentPair = this.implementationResolver.resolveIntents(component, operation);
        policyResult.addSourceProvidedIntents(operation, sourceImplementationIntentPair.getProvidedIntents());
        Set<PolicySet> policies = this.interactionResolver.resolvePolicySets(operation, (LogicalScaArtifact<?>)consumer, LocalBindingDefinition.INSTANCE.getType());
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        policies = this.implementationResolver.resolvePolicySets(component, operation);
        PolicyMetadata metadata = policyResult.getMetadata(operation);
        metadata.addAll(operation.getDefinition().getMetadata());
        metadata.addAll(((LogicalComponent)((LogicalAttachPoint)operation.getParent()).getParent()).getDefinition().getImplementation().getMetadata());
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        this.overrideDirectIfExternalAttachedPolicies(policyResult);
        return policyResult;
    }

    private PolicyResult resolvePolicies(List<LogicalOperation> operations, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding, LogicalComponent<?> source, LogicalComponent<?> target) throws PolicyResolutionException {
        if (this.noPolicy(source) && this.noPolicy(target)) {
            return EMPTY_RESULT;
        }
        PolicyResultImpl policyResult = new PolicyResultImpl();
        this.resolveEndpointPolicies(policyResult, sourceBinding, targetBinding);
        for (LogicalOperation operation : operations) {
            this.resolveOperationPolicies(operation, policyResult, sourceBinding, targetBinding, target);
        }
        this.overrideDirectIfExternalAttachedPolicies(policyResult);
        return policyResult;
    }

    private void overrideDirectIfExternalAttachedPolicies(PolicyResult policyResult) throws PolicyResolutionException {
        Set sets = policyResult.getInterceptedEndpointPolicySets();
        boolean overrode = this.overrideDirectIfExternalAttachedPolicies(sets);
        for (List policies : policyResult.getInterceptedPolicySets().values()) {
            if (!this.overrideDirectIfExternalAttachedPolicies(policies)) continue;
            overrode = true;
        }
        sets = policyResult.getSourcePolicy().getEndpointPolicySets();
        if (this.overrideDirectIfExternalAttachedPolicies(sets)) {
            overrode = true;
        }
        for (List policies : policyResult.getSourcePolicy().getOperationPolicySets().values()) {
            if (!this.overrideDirectIfExternalAttachedPolicies(policies)) continue;
            overrode = true;
        }
        sets = policyResult.getTargetPolicy().getEndpointPolicySets();
        if (this.overrideDirectIfExternalAttachedPolicies(sets)) {
            overrode = true;
        }
        for (List policies : policyResult.getTargetPolicy().getOperationPolicySets().values()) {
            if (!this.overrideDirectIfExternalAttachedPolicies(policies)) continue;
            overrode = true;
        }
        if (overrode) {
            this.validatePolicy(policyResult.getSourcePolicy());
            this.validatePolicy(policyResult.getTargetPolicy());
        }
    }

    private void validatePolicy(EffectivePolicy policy) throws PolicyResolutionException {
        Collection aggregatedIntents = policy.getAggregatedEndpointIntents();
        Set provideIntents = policy.getProvidedEndpointIntents();
        Set sets = policy.getEndpointPolicySets();
        this.validatePolicySets(aggregatedIntents, provideIntents, sets);
        aggregatedIntents = policy.getOperationIntents();
        for (List operationSets : policy.getOperationPolicySets().values()) {
            this.validatePolicySets(aggregatedIntents, provideIntents, operationSets);
        }
    }

    private void validatePolicySets(Collection<Intent> aggregatedIntents, Collection<Intent> provideIntents, Collection<PolicySet> sets) throws PolicyResolutionException {
        for (Intent intent : aggregatedIntents) {
            if (provideIntents.contains(intent)) continue;
            boolean provided = false;
            for (PolicySet set : sets) {
                if (!set.doesProvide(intent.getName())) continue;
                provided = true;
                break;
            }
            if (provided) continue;
            throw new PolicyResolutionException("Intent not satisfied by external attached policies:" + intent.getName());
        }
    }

    private boolean overrideDirectIfExternalAttachedPolicies(Collection<PolicySet> policies) {
        boolean externalAttachment = false;
        for (PolicySet policySet : policies) {
            if (policySet.getAttachTo() == null) continue;
            externalAttachment = true;
            break;
        }
        if (externalAttachment) {
            Iterator<PolicySet> iterator = policies.iterator();
            while (iterator.hasNext()) {
                PolicySet policySet;
                policySet = iterator.next();
                if (policySet.getAttachTo() != null) continue;
                iterator.remove();
            }
        }
        return externalAttachment;
    }

    private void resolveEndpointPolicies(PolicyResultImpl policyResult, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding) throws PolicyResolutionException {
        IntentPair sourceEndpointIntentPair = this.interactionResolver.resolveIntents(sourceBinding);
        policyResult.addSourceProvidedEndpointIntents(sourceEndpointIntentPair.getProvidedIntents());
        policyResult.addSourceAggregatedEndpointIntents(sourceEndpointIntentPair.getAggregatedIntents());
        IntentPair targetEndpointIntentPair = this.interactionResolver.resolveIntents(targetBinding);
        policyResult.addTargetProvidedEndpointIntents(targetEndpointIntentPair.getProvidedIntents());
        policyResult.addTargetAggregatedEndpointIntents(targetEndpointIntentPair.getAggregatedIntents());
        Set<PolicySet> endpointPolicies = this.interactionResolver.resolvePolicySets(sourceBinding);
        policyResult.addSourceEndpointPolicySets(CollectionUtils.filter(endpointPolicies, PROVIDED));
        policyResult.addInterceptedEndpointPolicySets(CollectionUtils.filter(endpointPolicies, INTERCEPTION));
        endpointPolicies = this.interactionResolver.resolvePolicySets(targetBinding);
        policyResult.addTargetEndpointPolicySets(CollectionUtils.filter(endpointPolicies, PROVIDED));
        policyResult.addInterceptedEndpointPolicySets(CollectionUtils.filter(endpointPolicies, INTERCEPTION));
    }

    private void resolveOperationPolicies(LogicalOperation operation, PolicyResultImpl policyResult, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding, LogicalComponent<?> target) throws PolicyResolutionException {
        QName sourceType = sourceBinding.getDefinition().getType();
        IntentPair sourcePair = this.interactionResolver.resolveIntents(operation, sourceType);
        policyResult.addSourceProvidedIntents(operation, sourcePair.getProvidedIntents());
        QName targetType = targetBinding.getDefinition().getType();
        IntentPair targetPair = this.interactionResolver.resolveIntents(operation, targetType);
        policyResult.addTargetProvidedIntents(operation, targetPair.getProvidedIntents());
        if (target != null) {
            IntentPair sourceImplementationPair = this.implementationResolver.resolveIntents(target, operation);
            policyResult.addSourceProvidedIntents(operation, sourceImplementationPair.getProvidedIntents());
        }
        Set<PolicySet> policies = this.interactionResolver.resolvePolicySets(operation, (LogicalScaArtifact<?>)sourceBinding, sourceType);
        policyResult.addSourcePolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        policies = this.interactionResolver.resolvePolicySets(operation, (LogicalScaArtifact<?>)targetBinding, targetType);
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        if (target != null && !(target.getDefinition().getImplementation() instanceof RemoteImplementation)) {
            Bindable parent = (Bindable)targetBinding.getParent();
            LogicalOperation targetOperation = this.matchOperation(operation, parent);
            policies = this.implementationResolver.resolvePolicySets(target, targetOperation);
            PolicyMetadata metadata = policyResult.getMetadata(operation);
            metadata.addAll(targetOperation.getDefinition().getMetadata());
            ComponentDefinition parentDefinition = ((LogicalComponent)((LogicalAttachPoint)targetOperation.getParent()).getParent()).getDefinition();
            Implementation parentImplementation = parentDefinition.getImplementation();
            metadata.addAll(parentImplementation.getMetadata());
            metadata.addAll(parentImplementation.getComponentType().getMetadata());
            policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
            policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        }
    }

    private LogicalOperation matchOperation(LogicalOperation operation, Bindable bindable) throws PolicyResolutionException {
        String name = operation.getDefinition().getName();
        List operations = bindable instanceof LogicalReference ? bindable.getCallbackOperations() : bindable.getOperations();
        try {
            LogicalOperation matched = this.operationResolver.resolve(operation, operations);
            if (matched == null) {
                throw new AssertionError((Object)("No matching operation for " + name));
            }
            return matched;
        }
        catch (OperationNotFoundException e) {
            throw new PolicyResolutionException((Throwable)e);
        }
    }

    private boolean noPolicy(LogicalComponent<?> component) {
        return component != null && (component.getDefinition().getImplementation().isType(IMPLEMENTATION_SYSTEM) || component.getDefinition().getImplementation().isType(IMPLEMENTATION_SINGLETON));
    }
}

