/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.definitions.ExternalAttachment;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.policy.infoset.PolicyEvaluationException;
import org.fabric3.policy.infoset.PolicyEvaluator;
import org.fabric3.spi.domain.generator.policy.PolicyAttacher;
import org.fabric3.spi.domain.generator.policy.PolicyRegistry;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.oasisopen.sca.annotation.Reference;

public class DefaultPolicyAttacher
implements PolicyAttacher {
    private PolicyEvaluator policyEvaluator;
    private PolicyRegistry policyRegistry;

    public DefaultPolicyAttacher(@Reference PolicyEvaluator policyEvaluator, @Reference PolicyRegistry policyRegistry) {
        this.policyEvaluator = policyEvaluator;
        this.policyRegistry = policyRegistry;
    }

    public void attachPolicies(LogicalComponent<?> component, boolean incremental) throws PolicyEvaluationException {
        Collection externalAttachments = this.policyRegistry.getAllDefinitions(ExternalAttachment.class);
        if (!externalAttachments.isEmpty()) {
            for (ExternalAttachment externalAttachment : externalAttachments) {
                for (QName name : externalAttachment.getPolicySets()) {
                    PolicySet policySet = (PolicySet)this.policyRegistry.getDefinition(name, PolicySet.class);
                    if (policySet == null) {
                        throw new PolicyEvaluationException("Policy set referenced in external attachment not found: " + name);
                    }
                    this.attachPolicy(component, policySet, externalAttachment.getAttachTo(), incremental);
                }
                for (QName name : externalAttachment.getIntents()) {
                    Intent intent = (Intent)this.policyRegistry.getDefinition(name, Intent.class);
                    if (intent != null) continue;
                    throw new PolicyEvaluationException("Intent referenced in external attachment not found: " + name);
                }
            }
        }
        Set policySets = this.policyRegistry.getExternalAttachmentPolicies();
        this.attachPolicies(policySets, component, incremental);
    }

    public void attachPolicies(Set<PolicySet> policySets, LogicalComponent<?> component, boolean incremental) throws PolicyEvaluationException {
        for (PolicySet policySet : policySets) {
            this.attachPolicy(component, policySet, policySet.getAttachTo(), incremental);
        }
    }

    public void detachPolicies(Set<PolicySet> policySets, LogicalComponent<?> component) throws PolicyEvaluationException {
        for (PolicySet policySet : policySets) {
            Collection<LogicalScaArtifact<?>> results = this.policyEvaluator.evaluate(policySet.getAttachTo(), component);
            Iterator<LogicalScaArtifact<?>> iterator = results.iterator();
            while (iterator.hasNext()) {
                LogicalScaArtifact<?> result = iterator.next();
                String appliesTo = policySet.getAppliesTo();
                if (appliesTo == null || this.policyEvaluator.doesApply(appliesTo, result)) continue;
                iterator.remove();
            }
            for (LogicalScaArtifact<?> result : results) {
                this.detach(policySet.getName(), result);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void attach(QName policySet, LogicalScaArtifact<?> target, boolean incremental) throws PolicyEvaluationException {
        if (target instanceof LogicalComponent) {
            LogicalComponent component = (LogicalComponent)target;
            if (component.getPolicySets().contains(policySet)) {
                return;
            }
            if (incremental && !component.getPolicySets().contains(policySet)) {
                component.addPolicySet(policySet);
                this.processComponent(component, policySet, incremental);
                return;
            } else {
                if (incremental) return;
                component.addPolicySet(policySet);
            }
            return;
        } else if (target instanceof LogicalService) {
            LogicalService service = (LogicalService)target;
            if (service.getPolicySets().contains(policySet) && incremental) {
                return;
            }
            service.addPolicySet(policySet);
            this.processService(service, policySet, incremental);
            return;
        } else if (target instanceof LogicalReference) {
            LogicalReference reference = (LogicalReference)target;
            if (reference.getPolicySets().contains(policySet)) {
                return;
            }
            reference.addPolicySet(policySet);
            this.processReference(reference, policySet, incremental);
            return;
        } else if (target instanceof LogicalOperation) {
            LogicalOperation operation = (LogicalOperation)target;
            if (operation.getPolicySets().contains(policySet)) {
                return;
            }
            operation.addPolicySet(policySet);
            LogicalAttachPoint attachPoint = (LogicalAttachPoint)operation.getParent();
            if (attachPoint instanceof LogicalReference) {
                this.processReference((LogicalReference)attachPoint, policySet, incremental);
                return;
            } else {
                if (!(attachPoint instanceof LogicalService)) throw new PolicyEvaluationException("Invalid policy attachment type: " + target.getClass());
                this.processService((LogicalService)attachPoint, policySet, incremental);
            }
            return;
        } else {
            if (!(target instanceof LogicalBinding)) throw new PolicyEvaluationException("Invalid policy attachment type: " + target.getClass());
            LogicalBinding binding = (LogicalBinding)target;
            if (binding.getPolicySets().contains(policySet)) {
                return;
            }
            binding.addPolicySet(policySet);
            binding.setState(LogicalState.NEW);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void detach(QName policySet, LogicalScaArtifact<?> target) throws PolicyEvaluationException {
        if (target instanceof LogicalComponent) {
            LogicalComponent component = (LogicalComponent)target;
            if (!component.getPolicySets().contains(policySet)) {
                return;
            }
            if (!component.getPolicySets().contains(policySet)) return;
            component.removePolicySet(policySet);
            this.processDetachComponent(component, policySet, true);
            return;
        } else if (target instanceof LogicalService) {
            LogicalService service = (LogicalService)target;
            if (!service.getPolicySets().contains(policySet)) {
                return;
            }
            service.removePolicySet(policySet);
            this.processDetachService(service, policySet, true);
            return;
        } else if (target instanceof LogicalReference) {
            LogicalReference reference = (LogicalReference)target;
            if (!reference.getPolicySets().contains(policySet)) {
                return;
            }
            reference.removePolicySet(policySet);
            this.processDetachReference(reference, policySet, true);
            return;
        } else if (target instanceof LogicalOperation) {
            LogicalOperation operation = (LogicalOperation)target;
            if (!operation.getPolicySets().contains(policySet)) {
                return;
            }
            operation.removePolicySet(policySet);
            LogicalAttachPoint attachPoint = (LogicalAttachPoint)operation.getParent();
            if (attachPoint instanceof LogicalReference) {
                this.processDetachReference((LogicalReference)attachPoint, policySet, true);
                return;
            } else {
                if (!(attachPoint instanceof LogicalService)) throw new PolicyEvaluationException("Invalid policy attachment type: " + target.getClass());
                this.processDetachService((LogicalService)attachPoint, policySet, true);
            }
            return;
        } else {
            if (!(target instanceof LogicalBinding)) throw new PolicyEvaluationException("Invalid policy attachment type: " + target.getClass());
            LogicalBinding binding = (LogicalBinding)target;
            if (!binding.getPolicySets().contains(policySet)) {
                return;
            }
            binding.removePolicySet(policySet);
            binding.setState(LogicalState.NEW);
        }
    }

    private void attachPolicy(LogicalComponent<?> component, PolicySet policySet, String attachTo, boolean incremental) throws PolicyEvaluationException {
        Collection<LogicalScaArtifact<?>> results = this.policyEvaluator.evaluate(attachTo, component);
        Iterator<LogicalScaArtifact<?>> iterator = results.iterator();
        while (iterator.hasNext()) {
            LogicalScaArtifact<?> result = iterator.next();
            String appliesTo = policySet.getAppliesTo();
            if (appliesTo == null || this.policyEvaluator.doesApply(appliesTo, result)) continue;
            iterator.remove();
        }
        for (LogicalScaArtifact<?> result : results) {
            this.attach(policySet.getName(), result, incremental);
        }
    }

    private void processComponent(LogicalComponent<?> component, QName policySet, boolean incremental) {
        for (LogicalReference reference : component.getReferences()) {
            this.processReference(reference, policySet, incremental);
        }
        for (LogicalService service : component.getServices()) {
            this.processService(service, policySet, incremental);
        }
    }

    private void processService(LogicalService service, QName policySet, boolean incremental) {
        for (LogicalBinding binding : service.getBindings()) {
            if (incremental && binding.getPolicySets().contains(policySet)) continue;
            binding.setState(LogicalState.NEW);
        }
    }

    private void processReference(LogicalReference reference, QName policySet, boolean incremental) {
        for (LogicalWire wire : reference.getWires()) {
            wire.setState(LogicalState.NEW);
        }
        for (LogicalBinding binding : reference.getBindings()) {
            if (incremental && binding.getPolicySets().contains(policySet)) continue;
            binding.setState(LogicalState.NEW);
        }
    }

    private void processDetachComponent(LogicalComponent<?> component, QName policySet, boolean incremental) {
        for (LogicalReference reference : component.getReferences()) {
            this.processDetachReference(reference, policySet, incremental);
        }
        for (LogicalService service : component.getServices()) {
            this.processDetachService(service, policySet, incremental);
        }
    }

    private void processDetachService(LogicalService service, QName policySet, boolean incremental) {
        for (LogicalBinding binding : service.getBindings()) {
            if (incremental && !binding.getPolicySets().contains(policySet)) continue;
            binding.setState(LogicalState.NEW);
        }
    }

    private void processDetachReference(LogicalReference reference, QName policySet, boolean incremental) {
        for (LogicalWire wire : reference.getWires()) {
            wire.setState(LogicalState.NEW);
        }
        for (LogicalBinding binding : reference.getBindings()) {
            if (incremental && !binding.getPolicySets().contains(policySet)) continue;
            binding.setState(LogicalState.NEW);
        }
    }
}

