/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.domain;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.SerializedDeploymentUnit;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.container.command.Response;
import org.fabric3.spi.container.command.ResponseCommand;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.DeployerMonitor;
import org.fabric3.spi.domain.DeploymentPackage;
import org.fabric3.spi.domain.generator.Deployment;
import org.fabric3.spi.domain.generator.DeploymentUnit;
import org.fabric3.spi.federation.topology.ControllerTopologyService;
import org.fabric3.spi.federation.topology.ErrorResponse;
import org.fabric3.spi.federation.topology.MessageException;
import org.fabric3.spi.federation.topology.Zone;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FederatedDeployer
implements Deployer {
    private DeployerMonitor monitor;
    private ControllerTopologyService topologyService;
    private SerializationService serializationService;
    private long timeout = 60000L;

    public FederatedDeployer(@Reference ControllerTopologyService topologyService, @Reference SerializationService serializationService, @Monitor DeployerMonitor monitor) {
        this.topologyService = topologyService;
        this.serializationService = serializationService;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void deploy(DeploymentPackage deploymentPackage) throws DeploymentException {
        Deployment currentDeployment = deploymentPackage.getCurrentDeployment();
        Deployment fullDeployment = deploymentPackage.getFullDeployment();
        for (String zoneName : currentDeployment.getZones()) {
            List responses;
            DeploymentCommand command;
            this.monitor.deploy(zoneName);
            try {
                command = this.createCommand(zoneName, currentDeployment, fullDeployment);
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
            Zone zone = new Zone(zoneName, Collections.emptyList());
            if (!this.topologyService.getZones().contains(zone)) {
                this.monitor.participantNotAvailable(zoneName);
                continue;
            }
            try {
                responses = this.topologyService.sendSynchronousToZone(zoneName, (ResponseCommand)command, true, this.timeout);
            }
            catch (MessageException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (responses.isEmpty()) {
                throw new DeploymentException("Deployment responses not received");
            }
            Response last = (Response)responses.get(responses.size() - 1);
            String runtimeName = last.getRuntimeName();
            if (!(last instanceof ErrorResponse)) continue;
            ErrorResponse response = (ErrorResponse)last;
            this.monitor.deploymentError(runtimeName, (Throwable)response.getException());
            throw new DeploymentException("Deployment errors encountered and logged");
        }
    }

    private DeploymentCommand createCommand(String zone, Deployment currentDeployment, Deployment fullDeployment) throws IOException {
        DeploymentUnit currentDeploymentUnit = currentDeployment.getDeploymentUnit(zone);
        SerializedDeploymentUnit currentSerializedUnit = this.createSerializedUnit(currentDeploymentUnit);
        DeploymentUnit fullDeploymentUnit = fullDeployment.getDeploymentUnit(zone);
        SerializedDeploymentUnit fullSerializedUnit = this.createSerializedUnit(fullDeploymentUnit);
        return new DeploymentCommand(zone, currentSerializedUnit, fullSerializedUnit);
    }

    private SerializedDeploymentUnit createSerializedUnit(DeploymentUnit deploymentUnit) throws IOException {
        List provisionCommands = deploymentUnit.getProvisionCommands();
        byte[] serializedProvisionCommands = this.serializationService.serialize((Serializable)((Object)provisionCommands));
        List extensionCommands = deploymentUnit.getExtensionCommands();
        byte[] serializedExtensionCommands = this.serializationService.serialize((Serializable)((Object)extensionCommands));
        List commands = deploymentUnit.getCommands();
        byte[] serializedCommands = this.serializationService.serialize((Serializable)((Object)commands));
        return new SerializedDeploymentUnit(serializedProvisionCommands, serializedExtensionCommands, serializedCommands);
    }
}

