/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.provisioning;

import java.net.URL;
import org.fabric3.api.annotation.monitor.Debug;
import org.fabric3.api.annotation.monitor.Info;
import org.fabric3.api.annotation.monitor.Severe;
import org.fabric3.api.annotation.monitor.Warning;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.AuthorizationException;

public interface ProvisionMonitor {
    @Severe
    public void errorMessage(String var1);

    @Severe
    public void error(String var1, Throwable var2);

    @Severe(value="HTTPS must be enabled for secure provisioning")
    public void httpsNotEnabled();

    @Warning(value="Username not set for secure contribution provisioning")
    public void warnUsername();

    @Warning(value="Password not set for secure contribution provisioning")
    public void warnPassword();

    @Info(value="Invalid authentication received when attempting to provision a contribution")
    public void badAuthentication(AuthenticationException var1);

    @Info(value="Invalid authorization received when attempting to provision a contribution")
    public void badAuthorization(AuthorizationException var1);

    @Debug(value="Resolving contribution {0}")
    public void resolving(URL var1);
}

