/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.provisioning;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.api.host.util.IOHelper;
import org.fabric3.federation.provisioning.AbstractResolverServlet;
import org.fabric3.federation.provisioning.ProvisionMonitor;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.security.AuthenticationService;
import org.fabric3.spi.security.AuthorizationService;

public class MetaDataStoreResolverServlet
extends AbstractResolverServlet {
    private static final long serialVersionUID = -5822568715938454572L;
    private transient MetaDataStore store;
    private boolean secure;

    protected MetaDataStoreResolverServlet(MetaDataStore store, AuthenticationService authenticationService, AuthorizationService authorizationService, String role, ProvisionMonitor monitor) {
        super(authenticationService, authorizationService, role, monitor);
        this.store = store;
        this.secure = true;
    }

    public MetaDataStoreResolverServlet(MetaDataStore store, ProvisionMonitor monitor) {
        super(null, null, null, monitor);
        this.store = store;
        this.secure = false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            this.monitor.errorMessage("Path info was null");
            resp.sendError(400);
            return;
        }
        int pos = path.lastIndexOf("/");
        if (pos < 0) {
            this.monitor.errorMessage("Invalid path info");
            resp.sendError(403);
            return;
        }
        if (this.secure && !this.checkAccess(req)) {
            resp.sendError(401);
            return;
        }
        String info = path.substring(pos + 1);
        try {
            URI uri = new URI(info);
            Contribution contribution = this.store.find(uri);
            if (contribution == null) {
                this.monitor.errorMessage("Contribution not found: " + info + ". Request URL was: " + info);
                resp.sendError(400);
                return;
            }
            URL url = contribution.getLocation();
            if (url == null) {
                throw new IOException("Contribution is not a physical artifact: " + uri);
            }
            IOHelper.copy((InputStream)url.openStream(), (OutputStream)resp.getOutputStream());
        }
        catch (URISyntaxException e) {
            this.monitor.error("Invalid URI", e);
            resp.sendError(400);
        }
    }
}

