/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.provisioning;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.fabric3.federation.provisioning.ProvisionCommand;
import org.fabric3.federation.provisioning.ProvisionMonitor;
import org.fabric3.federation.provisioning.ProvisionResponse;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.executor.ExecutionException;
import org.fabric3.spi.host.ServletHost;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;

@EagerInit
public abstract class AbstractProvisionCommandExecutor
implements CommandExecutor<ProvisionCommand> {
    private ServletHost host;
    private CommandExecutorRegistry registry;
    private boolean secure;
    private String address;
    private String mappingPath = "repository";
    protected ProvisionMonitor monitor;
    protected String role = "provision.client";

    public AbstractProvisionCommandExecutor(ServletHost host, CommandExecutorRegistry registry, ProvisionMonitor monitor) {
        this.host = host;
        this.registry = registry;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Property(required=false)
    public void setRole(String role) {
        this.role = role;
    }

    @Property(required=false)
    public void setMappingPath(String path) {
        this.mappingPath = path;
    }

    @Property(required=false)
    public void setAddress(String address) {
        this.address = address;
    }

    @Init
    public void init() throws UnknownHostException {
        HttpServlet servlet;
        if (this.address == null) {
            this.address = InetAddress.getLocalHost().getHostAddress();
        }
        if (this.secure && !this.host.isHttpsEnabled()) {
            this.monitor.httpsNotEnabled();
            servlet = this.getResolverServlet(false);
        } else {
            servlet = this.getResolverServlet(this.secure);
        }
        this.host.registerMapping("/" + this.mappingPath + "/*", (Servlet)servlet);
        this.registry.register(ProvisionCommand.class, (CommandExecutor)this);
    }

    public void execute(ProvisionCommand command) throws ContainerException {
        try {
            URI contributionUri = command.getContributionUri();
            String path = "/" + this.mappingPath;
            URL contributionUrl = this.secure ? new URL("https://" + this.address + ":" + this.host.getHttpsPort() + path + "/" + contributionUri) : new URL("http://" + this.address + ":" + this.host.getHttpPort() + path + "/" + contributionUri);
            ProvisionResponse response = new ProvisionResponse(contributionUrl);
            command.setResponse(response);
        }
        catch (MalformedURLException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected abstract HttpServlet getResolverServlet(boolean var1);
}

