/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import org.fabric3.implementation.java.provision.JavaWireTargetDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.MethodUtils;
import org.fabric3.implementation.pojo.component.InvokerInterceptor;
import org.fabric3.implementation.pojo.provision.PojoWireSourceDefinition;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvoker;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Reference;

public class JavaTargetWireAttacher
implements TargetWireAttacher<JavaWireTargetDefinition> {
    private final ComponentManager manager;
    private ReflectionFactory reflectionFactory;
    private final ClassLoaderRegistry classLoaderRegistry;

    public JavaTargetWireAttacher(@Reference ComponentManager manager, @Reference ReflectionFactory reflectionFactory, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.reflectionFactory = reflectionFactory;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalWireSourceDefinition sourceDefinition, JavaWireTargetDefinition targetDefinition, Wire wire) throws ContainerException {
        URI targetName = UriHelper.getDefragmentedName((URI)targetDefinition.getUri());
        Component component = this.manager.getComponent(targetName);
        if (component == null) {
            throw new ContainerException("Target not found: " + targetName);
        }
        JavaComponent target = (JavaComponent)component;
        Class implementationClass = target.getImplementationClass();
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(targetDefinition.getClassLoaderId());
        for (InvocationChain chain : wire.getInvocationChains()) {
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            Method method = MethodUtils.findMethod((PhysicalWireSourceDefinition)sourceDefinition, (PhysicalWireTargetDefinition)targetDefinition, (PhysicalOperationDefinition)operation, (Class)implementationClass, (ClassLoader)loader, (ClassLoaderRegistry)this.classLoaderRegistry);
            ServiceInvoker invoker = this.reflectionFactory.createServiceInvoker(method);
            InvokerInterceptor interceptor = sourceDefinition instanceof PojoWireSourceDefinition && targetDefinition.getClassLoaderId().equals(sourceDefinition.getClassLoaderId()) ? new InvokerInterceptor(invoker, (AtomicComponent)target) : new InvokerInterceptor(invoker, (AtomicComponent)target, loader);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalWireSourceDefinition source, JavaWireTargetDefinition target) throws ContainerException {
    }

    public ObjectFactory<?> createObjectFactory(JavaWireTargetDefinition target) throws ContainerException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        JavaComponent targetComponent = (JavaComponent)this.manager.getComponent(targetId);
        return targetComponent.createObjectFactory();
    }
}

