/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.implementation.java.provision.JavaWireSourceDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.PojoSourceWireAttacher;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaSourceWireAttacher
extends PojoSourceWireAttacher
implements SourceWireAttacher<JavaWireSourceDefinition> {
    private ComponentManager manager;
    private WireProxyService proxyService;

    public JavaSourceWireAttacher(@Reference ComponentManager manager, @Reference WireProxyService proxyService, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference TransformerRegistry transformerRegistry) {
        super(transformerRegistry, classLoaderRegistry);
        this.manager = manager;
        this.proxyService = proxyService;
    }

    public void attach(JavaWireSourceDefinition sourceDefinition, PhysicalWireTargetDefinition targetDefinition, Wire wire) throws ContainerException {
        Class type;
        URI sourceName = UriHelper.getDefragmentedName((URI)sourceDefinition.getUri());
        JavaComponent source = (JavaComponent)this.manager.getComponent(sourceName);
        if (source == null) {
            throw new ContainerException("Source callback not found: " + sourceName);
        }
        Injectable injectable = sourceDefinition.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(sourceDefinition.getClassLoaderId(), sourceDefinition.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = sourceDefinition.getInterfaceName();
            throw new ContainerException("Unable to load interface class: " + name, (Throwable)e);
        }
        if (InjectableType.CALLBACK.equals((Object)injectable.getType())) {
            this.processCallback(wire, targetDefinition, source, injectable, type);
        } else {
            this.processReference(wire, sourceDefinition, targetDefinition, source, injectable, type);
        }
    }

    public void detach(JavaWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        this.detachObjectFactory(source, target);
    }

    public void detachObjectFactory(JavaWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }

    public void attachObjectFactory(JavaWireSourceDefinition sourceDefinition, ObjectFactory<?> factory, PhysicalWireTargetDefinition targetDefinition) throws ContainerException {
        URI sourceId = UriHelper.getDefragmentedName((URI)sourceDefinition.getUri());
        JavaComponent sourceComponent = (JavaComponent)this.manager.getComponent(sourceId);
        Injectable injectable = sourceDefinition.getInjectable();
        if (sourceDefinition.isKeyed() || sourceDefinition.isOrdered()) {
            Object key = this.getKey(sourceDefinition, targetDefinition);
            int order = sourceDefinition.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            sourceComponent.setObjectFactory(injectable, factory, attributes);
        } else {
            sourceComponent.setObjectFactory(injectable, factory);
        }
    }

    private void processReference(Wire wire, JavaWireSourceDefinition sourceDefinition, PhysicalWireTargetDefinition targetDefinition, JavaComponent source, Injectable injectable, Class<?> type) throws ContainerException {
        String callbackUri = null;
        URI uri = targetDefinition.getCallbackUri();
        if (uri != null) {
            callbackUri = uri.toString();
        }
        ObjectFactory factory = this.proxyService.createObjectFactory(type, wire, callbackUri);
        if (sourceDefinition.isKeyed() || sourceDefinition.isOrdered()) {
            Object key = this.getKey(sourceDefinition, targetDefinition);
            int order = sourceDefinition.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            source.setObjectFactory(injectable, factory, attributes);
        } else {
            source.setObjectFactory(injectable, factory);
        }
    }

    private void processCallback(Wire wire, PhysicalWireTargetDefinition targetDefinition, JavaComponent source, Injectable injectable, Class<?> type) throws ContainerException {
        URI callbackUri = targetDefinition.getUri();
        ScopeContainer container = source.getScopeContainer();
        ObjectFactory factory = source.getObjectFactory(injectable);
        boolean multiThreaded = Scope.COMPOSITE.equals((Object)container.getScope());
        factory = factory == null ? this.proxyService.createCallbackObjectFactory(type, multiThreaded, callbackUri, wire) : this.proxyService.updateCallbackObjectFactory(factory, type, multiThreaded, callbackUri, wire);
        source.setObjectFactory(injectable, factory);
    }
}

