/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.java.provision.JavaConnectionSourceDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.spi.proxy.ChannelProxyService;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaSourceConnectionAttacher
implements SourceConnectionAttacher<JavaConnectionSourceDefinition> {
    private ComponentManager manager;
    private ChannelProxyService proxyService;
    private ClassLoaderRegistry classLoaderRegistry;

    public JavaSourceConnectionAttacher(@Reference ComponentManager manager, @Reference ChannelProxyService proxyService, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.proxyService = proxyService;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(JavaConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        Class type;
        URI sourceUri = source.getUri();
        URI sourceName = UriHelper.getDefragmentedName((URI)sourceUri);
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        if (component == null) {
            throw new ContainerException("Source component not found: " + sourceName);
        }
        Injectable injectable = source.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(source.getClassLoaderId(), source.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = source.getInterfaceName();
            throw new ContainerException("Unable to load interface class: " + name, (Throwable)e);
        }
        ObjectFactory factory = this.proxyService.createObjectFactory(type, connection);
        component.setObjectFactory(injectable, factory);
    }

    public void detach(JavaConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ContainerException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }
}

