/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.implementation.java.provision.JavaComponentDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.java.runtime.NonManagedImplementationManagerFactory;
import org.fabric3.implementation.pojo.builder.PojoComponentBuilder;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaComponentBuilder
extends PojoComponentBuilder<JavaComponentDefinition, JavaComponent> {
    private ScopeRegistry scopeRegistry;
    private ImplementationManagerFactoryBuilder factoryBuilder;

    public JavaComponentBuilder(@Reference ScopeRegistry scopeRegistry, @Reference ImplementationManagerFactoryBuilder factoryBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference PropertyObjectFactoryBuilder propertyBuilder, @Reference ManagementService managementService, @Reference IntrospectionHelper helper, @Reference HostInfo info) {
        super(classLoaderRegistry, propertyBuilder, managementService, helper, info);
        this.scopeRegistry = scopeRegistry;
        this.factoryBuilder = factoryBuilder;
    }

    public JavaComponent build(JavaComponentDefinition definition) throws ContainerException {
        if (definition.getInstance() != null) {
            return this.buildNonManagedComponent(definition);
        }
        return this.buildManagedComponent(definition);
    }

    public void dispose(JavaComponentDefinition definition, JavaComponent component) throws ContainerException {
        this.dispose(definition);
    }

    private JavaComponent buildManagedComponent(JavaComponentDefinition definition) throws ContainerException {
        URI uri = definition.getComponentUri();
        QName deployable = definition.getDeployable();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderId());
        String scopeName = definition.getScope();
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(scopeName);
        ImplementationManagerDefinition managerDefinition = definition.getFactoryDefinition();
        ImplementationManagerFactory factory = this.factoryBuilder.build(managerDefinition, classLoader);
        this.createPropertyFactories(definition, factory);
        boolean eager = definition.isEagerInit();
        JavaComponent component = new JavaComponent(uri, factory, scopeContainer, deployable, eager);
        this.buildContexts(component, factory);
        this.export(definition, classLoader, (AtomicComponent)component);
        return component;
    }

    private JavaComponent buildNonManagedComponent(JavaComponentDefinition definition) {
        URI componentUri = definition.getComponentUri();
        String scopeName = definition.getScope();
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(scopeName);
        Object instance = definition.getInstance();
        NonManagedImplementationManagerFactory factory = new NonManagedImplementationManagerFactory(instance);
        return new JavaComponent(componentUri, factory, scopeContainer, definition.getDeployable(), false);
    }
}

