/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.ServiceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class JavaServiceHeuristic
implements HeuristicProcessor {
    private IntrospectionHelper helper;
    private JavaContractProcessor contractProcessor;
    private PolicyAnnotationProcessor policyProcessor;
    private OperationPolicyIntrospector policyIntrospector;
    private boolean strictSCA;

    public JavaServiceHeuristic(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor, @Reference OperationPolicyIntrospector policyIntrospector) {
        this.helper = helper;
        this.contractProcessor = contractProcessor;
        this.policyIntrospector = policyIntrospector;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:sca/@enable.sca.annotations")
    public void setStrictSCA(boolean strictSCA) {
        this.strictSCA = strictSCA;
    }

    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        if (!componentType.getServices().isEmpty()) {
            for (AbstractService definition : componentType.getServices().values()) {
                Class<?> serviceInterface;
                JavaServiceContract contract = (JavaServiceContract)definition.getServiceContract();
                try {
                    serviceInterface = implClass.getClassLoader().loadClass(contract.getInterfaceClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
                this.introspectPolicy(serviceInterface, implClass, (ServiceContract)contract, definition, context);
            }
            return;
        }
        Set interfaces = this.helper.getImplementedInterfaces(implClass);
        if (!this.strictSCA) {
            if (interfaces.isEmpty()) {
                ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, implClass, (ComponentType)componentType, context);
                componentType.add(serviceDefinition);
            } else {
                for (Class interfaze : interfaces) {
                    Package pkg = interfaze.getPackage();
                    if (interfaze.isAnnotationPresent(Management.class) || pkg == null || pkg.getName().startsWith("java")) continue;
                    ServiceDefinition serviceDefinition = this.createServiceDefinition(interfaze, implClass, (ComponentType)componentType, context);
                    componentType.add(serviceDefinition);
                }
            }
        } else if (interfaces.size() == 1) {
            Class service = (Class)interfaces.iterator().next();
            ServiceDefinition serviceDefinition = this.createServiceDefinition(service, implClass, (ComponentType)componentType, context);
            componentType.add(serviceDefinition);
        } else if (interfaces.size() == 2) {
            ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, implClass, (ComponentType)componentType, context);
            componentType.add(serviceDefinition);
        } else {
            ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, implClass, (ComponentType)componentType, context);
            componentType.add(serviceDefinition);
        }
    }

    private ServiceDefinition createServiceDefinition(Class<?> serviceInterface, Class<?> implClass, ComponentType componentType, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, context, new ModelObject[]{componentType});
        ServiceDefinition definition = new ServiceDefinition(contract.getInterfaceName(), (ServiceContract)contract);
        this.introspectPolicy(serviceInterface, implClass, (ServiceContract)contract, (AbstractService)definition, context);
        return definition;
    }

    private void introspectPolicy(Class<?> serviceInterface, Class<?> implClass, ServiceContract contract, AbstractService definition, IntrospectionContext context) {
        Annotation[] annotations = serviceInterface.getAnnotations();
        if (this.policyProcessor != null) {
            for (Annotation annotation : annotations) {
                this.policyProcessor.process(annotation, (PolicyAware)definition, context);
            }
            this.policyIntrospector.introspectPolicyOnOperations(contract, implClass, context);
        }
    }
}

