/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.implementation.java.introspection.JavaImplementationIntrospector;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaImplementationLoader
extends AbstractValidatingTypeLoader<JavaImplementation> {
    private JavaImplementationIntrospector introspector;
    private LoaderHelper loaderHelper;

    public JavaImplementationLoader(@Reference JavaImplementationIntrospector introspector, @Reference LoaderHelper loaderHelper) {
        this.introspector = introspector;
        this.loaderHelper = loaderHelper;
        this.addAttributes(new String[]{"class", "requires", "policySets"});
    }

    public JavaImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        JavaImplementation implementation = new JavaImplementation();
        this.validateAttributes(reader, introspectionContext, new ModelObject[]{implementation});
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("The class attribute was not specified", startLocation, new ModelObject[0]);
            introspectionContext.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return implementation;
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)implementation, reader, introspectionContext);
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        implementation.setImplementationClass(implClass);
        InjectingComponentType componentType = new InjectingComponentType(implClass);
        this.introspector.introspect(componentType, introspectionContext);
        implementation.setComponentType((ComponentType)componentType);
        return implementation;
    }
}

