/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.generator;

import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.implementation.java.generator.JavaGenerationHelper;
import org.fabric3.implementation.java.provision.JavaComponentDefinition;
import org.fabric3.implementation.java.provision.JavaConnectionSourceDefinition;
import org.fabric3.implementation.java.provision.JavaConnectionTargetDefinition;
import org.fabric3.implementation.java.provision.JavaWireSourceDefinition;
import org.fabric3.implementation.java.provision.JavaWireTargetDefinition;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.component.ComponentGenerator;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.physical.PhysicalComponentDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaComponentGenerator
implements ComponentGenerator<LogicalComponent<JavaImplementation>> {
    protected final GenerationHelper ifHelper;
    private JavaGenerationHelper generationHelper;

    public JavaComponentGenerator(@Reference JavaGenerationHelper generationHelper, @Reference GenerationHelper ifHelper) {
        this.generationHelper = generationHelper;
        this.ifHelper = ifHelper;
    }

    public PhysicalComponentDefinition generate(LogicalComponent<JavaImplementation> component) throws GenerationException {
        Object instance = ((JavaImplementation)component.getDefinition().getImplementation()).getInstance();
        if (instance != null) {
            JavaComponentDefinition definition = new JavaComponentDefinition(instance);
            definition.setScope("COMPOSITE");
            return definition;
        }
        JavaComponentDefinition definition = new JavaComponentDefinition();
        this.generationHelper.generate(definition, component);
        return definition;
    }

    public PhysicalWireSourceDefinition generateSource(LogicalReference reference, EffectivePolicy policy) throws GenerationException {
        JavaWireSourceDefinition definition = new JavaWireSourceDefinition();
        this.generationHelper.generateWireSource(definition, reference, policy);
        return definition;
    }

    public PhysicalWireSourceDefinition generateCallbackSource(LogicalService service, EffectivePolicy policy) throws GenerationException {
        JavaWireSourceDefinition definition = new JavaWireSourceDefinition();
        ServiceContract callbackContract = service.getDefinition().getServiceContract().getCallbackContract();
        LogicalComponent source = service.getLeafComponent();
        this.generationHelper.generateCallbackWireSource(definition, (LogicalComponent<? extends JavaImplementation>)source, callbackContract, policy);
        return definition;
    }

    public PhysicalWireTargetDefinition generateTarget(LogicalService service, EffectivePolicy policy) throws GenerationException {
        JavaWireTargetDefinition definition = new JavaWireTargetDefinition();
        this.generationHelper.generateWireTarget(definition, service);
        return definition;
    }

    public PhysicalConnectionSourceDefinition generateConnectionSource(LogicalProducer producer) throws GenerationException {
        JavaConnectionSourceDefinition definition = new JavaConnectionSourceDefinition();
        this.generationHelper.generateConnectionSource(definition, producer);
        return definition;
    }

    public PhysicalConnectionTargetDefinition generateConnectionTarget(LogicalConsumer consumer) throws GenerationException {
        JavaConnectionTargetDefinition definition = new JavaConnectionTargetDefinition();
        this.generationHelper.generateConnectionTarget(definition, consumer);
        return definition;
    }

    public PhysicalWireSourceDefinition generateResourceSource(LogicalResourceReference<?> resourceReference) throws GenerationException {
        JavaWireSourceDefinition definition = new JavaWireSourceDefinition();
        this.generationHelper.generateResourceWireSource(definition, resourceReference);
        return definition;
    }
}

