/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.resource.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ResourceReferenceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.resource.model.SystemSourcedResourceReference;
import org.fabric3.resource.spi.JSR250ResourceTypeHandler;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Reference;

public class JSR250ResourceProcessor
extends AbstractAnnotationProcessor<Resource> {
    private IntrospectionHelper helper;
    private JavaContractProcessor contractProcessor;
    private Map<Class<?>, JSR250ResourceTypeHandler> handlers = new HashMap();

    @Reference(required=false)
    public void setHandlers(Map<Class<?>, JSR250ResourceTypeHandler> handlers) {
        this.handlers = handlers;
    }

    public JSR250ResourceProcessor(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor) {
        super(Resource.class);
        this.helper = helper;
        this.contractProcessor = contractProcessor;
    }

    public void visitField(Resource annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        ResourceReferenceDefinition definition;
        String name = this.helper.getSiteName(field, annotation.name());
        Type genericType = field.getGenericType();
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        FieldInjectionSite site = new FieldInjectionSite(field);
        JSR250ResourceTypeHandler handler = this.handlers.get(type);
        if (handler != null) {
            definition = handler.createResourceReference(name, annotation, field, context);
        } else {
            String mappedName = annotation.mappedName();
            if (mappedName.length() == 0) {
                mappedName = type.getSimpleName();
            }
            definition = this.createResource(name, type, false, mappedName, componentType, context);
        }
        componentType.add(definition, (InjectionSite)site);
    }

    public void visitMethod(Resource annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        ResourceReferenceDefinition definition;
        String name = this.helper.getSiteName(method, annotation.name());
        Type genericType = this.helper.getGenericType(method);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        JSR250ResourceTypeHandler handler = this.handlers.get(type);
        if (handler != null) {
            definition = handler.createResourceReference(name, annotation, method, context);
        } else {
            String mappedName = annotation.mappedName();
            if (mappedName.length() == 0) {
                mappedName = type.getSimpleName();
            }
            definition = this.createResource(name, type, false, mappedName, componentType, context);
        }
        componentType.add(definition, (InjectionSite)site);
    }

    private SystemSourcedResourceReference createResource(String name, Class<?> type, boolean optional, String mappedName, InjectingComponentType componentType, IntrospectionContext context) {
        JavaServiceContract serviceContract = this.contractProcessor.introspect(type, context, new ModelObject[]{componentType});
        return new SystemSourcedResourceReference(name, optional, mappedName, (ServiceContract)serviceContract);
    }
}

