/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.net.MalformedURLException;
import java.net.URL;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Node;

public class Property2URLTransformer
implements SingleTypeTransformer<Node, URL> {
    private static final JavaType TARGET = new JavaType(URL.class);

    public DataType getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType getTargetType() {
        return TARGET;
    }

    public URL transform(Node node, ClassLoader loader) throws TransformationException {
        URL url;
        String content = node.getTextContent();
        try {
            url = new URL(node.getTextContent());
        }
        catch (MalformedURLException me) {
            throw new TransformationException("Unable to create URL :- " + content, (Throwable)me);
        }
        return url;
    }
}

