/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import javax.xml.namespace.QName;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Node;

public class Property2QNameTransformer
implements SingleTypeTransformer<Node, QName> {
    private static final JavaType TARGET = new JavaType(QName.class);

    public DataType getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType getTargetType() {
        return TARGET;
    }

    public QName transform(Node node, ClassLoader loader) throws TransformationException {
        String prefix;
        String uri;
        String content = node.getTextContent();
        int index = content.indexOf(58);
        if (index != -1 && (uri = node.lookupNamespaceURI(prefix = content.substring(0, index))) != null) {
            String localPart = content.substring(index + 1);
            return new QName(uri, localPart, prefix);
        }
        try {
            return QName.valueOf(content);
        }
        catch (IllegalArgumentException ie) {
            throw new TransformationException("Unable to transform on QName ", (Throwable)ie);
        }
    }
}

