/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.util.Properties;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Property2PropertiesTransformer
implements SingleTypeTransformer<Node, Properties> {
    private static final JavaType TARGET = new JavaType(Properties.class);

    public DataType getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType getTargetType() {
        return TARGET;
    }

    public Properties transform(Node node, ClassLoader loader) throws TransformationException {
        Properties properties = new Properties();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            properties.put(element.getTagName(), child.getTextContent());
        }
        return properties;
    }
}

