/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Node;

public class Property2DoubleTransformer
implements SingleTypeTransformer<Node, Double> {
    private static final JavaType TARGET = new JavaType(Double.class);

    public DataType getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType getTargetType() {
        return TARGET;
    }

    public Double transform(Node node, ClassLoader loader) throws TransformationException {
        try {
            return Double.valueOf(node.getTextContent());
        }
        catch (NumberFormatException ex) {
            throw new TransformationException("Unsupportable double " + node.getTextContent(), (Throwable)ex);
        }
    }
}

