/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerFactory;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

public class DefaultTransformerRegistry
implements TransformerRegistry {
    private static final Comparator<TransformerFactory> COMPARATOR = new Comparator<TransformerFactory>(){

        @Override
        public int compare(TransformerFactory first, TransformerFactory second) {
            return first.getOrder() - second.getOrder();
        }
    };
    private Map<Key, SingleTypeTransformer<?, ?>> transformers = new HashMap();
    private List<TransformerFactory> factories = new ArrayList<TransformerFactory>();

    @Reference(required=false)
    public void setTransformers(List<SingleTypeTransformer<?, ?>> transformers) {
        for (SingleTypeTransformer<?, ?> transformer : transformers) {
            Key pair = new Key(transformer.getSourceType(), transformer.getTargetType());
            this.transformers.put(pair, transformer);
        }
    }

    @Reference(required=false)
    public void setFactories(List<TransformerFactory> factories) {
        ArrayList<TransformerFactory> sorted = new ArrayList<TransformerFactory>(factories);
        Collections.sort(sorted, COMPARATOR);
        this.factories = sorted;
    }

    public Transformer<?, ?> getTransformer(DataType source, DataType target, List<Class<?>> inTypes, List<Class<?>> outTypes) throws TransformationException {
        Key key = new Key(source, target);
        Transformer transformer = (Transformer)this.transformers.get(key);
        if (transformer != null) {
            return transformer;
        }
        for (TransformerFactory factory : this.factories) {
            boolean canTransform = factory.canTransform(source, target);
            if (!canTransform) continue;
            return factory.create(source, target, inTypes, outTypes);
        }
        return null;
    }

    private static class Key {
        private final DataType source;
        private final DataType target;

        public Key(DataType source, DataType target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.source.equals((Object)that.source) && this.target.equals((Object)that.target);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }
    }
}

