/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node.nonmanaged;

import org.fabric3.implementation.pojo.spi.proxy.ChannelProxyService;
import org.fabric3.node.nonmanaged.NonManagedPhysicalConnectionSourceDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.Reference;

public class NonManagedConnectionSourceWireAttacher
implements SourceConnectionAttacher<NonManagedPhysicalConnectionSourceDefinition> {
    private ChannelProxyService proxyService;
    private ClassLoaderRegistry classLoaderRegistry;

    public NonManagedConnectionSourceWireAttacher(@Reference ChannelProxyService proxyService, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.proxyService = proxyService;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(NonManagedPhysicalConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        try {
            ClassLoader loader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
            Class<?> interfaze = loader.loadClass(source.getInterface());
            Object proxy = this.proxyService.createObjectFactory(interfaze, connection).getInstance();
            source.setProxy(proxy);
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    public void detach(NonManagedPhysicalConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ContainerException {
    }
}

