/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node.nonmanaged;

import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.node.nonmanaged.NonManagedPhysicalWireSourceDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class NonManagedComponentSourceWireAttacher
implements SourceWireAttacher<NonManagedPhysicalWireSourceDefinition> {
    private WireProxyService proxyService;
    private ClassLoaderRegistry registry;

    public NonManagedComponentSourceWireAttacher(@Reference WireProxyService proxyService, @Reference ClassLoaderRegistry registry) {
        this.proxyService = proxyService;
        this.registry = registry;
    }

    public void attach(NonManagedPhysicalWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws ContainerException {
        try {
            ClassLoader loader = this.registry.getClassLoader(source.getClassLoaderId());
            Class<?> interfaze = loader.loadClass(source.getInterface());
            Object proxy = this.proxyService.createObjectFactory(interfaze, wire, null).getInstance();
            source.setProxy(proxy);
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    public void attachObjectFactory(NonManagedPhysicalWireSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition target) throws ContainerException {
        source.setProxy(objectFactory.getInstance());
    }

    public void detach(NonManagedPhysicalWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
    }

    public void detachObjectFactory(NonManagedPhysicalWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
    }
}

