/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node.domain;

import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.AbstractReference;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentReference;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.node.NotFoundException;
import org.fabric3.node.domain.ContributionResolver;
import org.fabric3.node.domain.Introspector;
import org.fabric3.node.domain.ResolverException;
import org.fabric3.node.domain.ServiceResolver;
import org.fabric3.node.nonmanaged.NonManagedImplementation;
import org.fabric3.node.nonmanaged.NonManagedPhysicalWireSourceDefinition;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.Connector;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.binding.BindingSelector;
import org.fabric3.spi.domain.generator.wire.WireGenerator;
import org.fabric3.spi.domain.instantiator.AutowireResolver;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class ServiceResolverImpl
implements ServiceResolver {
    private static final QName SYNTHETIC_DEPLOYABLE = new QName("urn:fabric3.org:synthesized", "Synthetic");
    private Introspector introspector;
    private LogicalComponentManager lcm;
    private AutowireResolver autowireResolver;
    private BindingSelector bindingSelector;
    private WireGenerator wireGenerator;
    private Connector connector;
    private HostInfo info;
    private AtomicInteger idCounter = new AtomicInteger();

    public ServiceResolverImpl(@Reference Introspector introspector, @Reference(name="lcm") LogicalComponentManager lcm, @Reference AutowireResolver autowireResolver, @Reference BindingSelector bindingSelector, @Reference WireGenerator wireGenerator, @Reference Connector connector, @Reference HostInfo info) {
        this.introspector = introspector;
        this.lcm = lcm;
        this.autowireResolver = autowireResolver;
        this.bindingSelector = bindingSelector;
        this.wireGenerator = wireGenerator;
        this.connector = connector;
        this.info = info;
    }

    @Override
    public <T> T resolve(Class<T> interfaze) throws ResolverException {
        LogicalWire wire = this.createWire(interfaze);
        try {
            PhysicalWireDefinition pwd;
            boolean remote;
            boolean bl = remote = !((LogicalComponent)wire.getSource().getParent()).getZone().equals(((LogicalComponent)wire.getTarget().getParent()).getZone());
            if (remote) {
                this.bindingSelector.selectBinding(wire);
                pwd = this.wireGenerator.generateBoundReference(wire.getSourceBinding());
                pwd.getSource().setUri(((LogicalComponent)wire.getSource().getParent()).getUri());
            } else {
                pwd = this.wireGenerator.generateWire(wire);
            }
            NonManagedPhysicalWireSourceDefinition source = (NonManagedPhysicalWireSourceDefinition)pwd.getSource();
            URI uri = ContributionResolver.getContribution(interfaze);
            pwd.getTarget().setClassLoaderId(uri);
            source.setClassLoaderId(uri);
            this.connector.connect(pwd);
            return interfaze.cast(source.getProxy());
        }
        catch (ContainerException | GenerationException e) {
            throw new ResolverException(e);
        }
    }

    private <T> LogicalWire createWire(Class<T> interfaze) throws ResolverException {
        LogicalCompositeComponent domainComponent;
        JavaServiceContract contract = this.introspector.introspect(interfaze);
        LogicalReference logicalReference = this.createReference(contract);
        List services = this.autowireResolver.resolve(logicalReference, (ServiceContract)contract, domainComponent = this.lcm.getRootComponent());
        if (services.isEmpty()) {
            throw new NotFoundException("Service not found for type: " + interfaze.getName());
        }
        LogicalService targetService = (LogicalService)services.get(0);
        return new LogicalWire((LogicalComponent)domainComponent, logicalReference, targetService, SYNTHETIC_DEPLOYABLE, true);
    }

    private LogicalReference createReference(JavaServiceContract contract) {
        LogicalCompositeComponent domainComponent = this.lcm.getRootComponent();
        int id = this.idCounter.getAndIncrement();
        String name = "Synthetic" + id;
        URI componentUri = URI.create(domainComponent.getUri().toString() + "/" + name);
        URI referenceUri = URI.create(componentUri.toString() + "#reference");
        QName qName = new QName("urn:fabric3.org:synthesized", "SyntheticComposite" + id);
        Composite composite = new Composite(qName);
        ComponentDefinition componentDefinition = new ComponentDefinition(name);
        componentDefinition.setParent((ModelObject)composite);
        NonManagedImplementation implementation = new NonManagedImplementation();
        componentDefinition.setImplementation((Implementation)implementation);
        ComponentReference reference = new ComponentReference("reference", Multiplicity.ONE_ONE);
        componentDefinition.add(reference);
        LogicalComponent logicalComponent = new LogicalComponent(componentUri, componentDefinition, domainComponent);
        logicalComponent.setZone(this.info.getZoneName());
        reference.setServiceContract((ServiceContract)contract);
        LogicalReference logicalReference = new LogicalReference(referenceUri, (AbstractReference)reference, logicalComponent);
        logicalReference.setServiceContract((ServiceContract)contract);
        logicalComponent.addReference(logicalReference);
        return logicalReference;
    }
}

