/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node.domain;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.builder.JavaComponentDefinitionBuilder;
import org.fabric3.api.model.type.component.ChannelDefinition;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.ServiceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.node.domain.ContributionResolver;
import org.fabric3.node.domain.DeploymentException;
import org.fabric3.node.domain.Provisioner;
import org.fabric3.node.domain.ValidationDeploymentException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ComponentProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class ProvisionerImpl
implements Provisioner {
    private JavaContractProcessor contractProcessor;
    private ComponentProcessor componentProcessor;
    private MetaDataStore metaDataStore;
    private Domain domain;

    public ProvisionerImpl(@Reference JavaContractProcessor contractProcessor, @Reference ComponentProcessor componentProcessor, @Reference MetaDataStore metaDataStore, @Reference(name="domain") Domain domain) {
        this.contractProcessor = contractProcessor;
        this.componentProcessor = componentProcessor;
        this.metaDataStore = metaDataStore;
        this.domain = domain;
    }

    @Override
    public void deploy(String name, Object instance, Class<?> ... interfaces) throws DeploymentException {
        ComponentDefinition definition = JavaComponentDefinitionBuilder.newBuilder((String)name, (Object)instance).build();
        if (interfaces == null) {
            Class<?>[] implementedInterfaces = this.getClass().getInterfaces();
            if (implementedInterfaces.length == 0) {
                this.addService(instance.getClass(), definition);
            } else {
                for (Class<?> interfaze : implementedInterfaces) {
                    this.addService(interfaze, definition);
                }
            }
        } else {
            for (Class<?> interfaze : interfaces) {
                this.addService(interfaze, definition);
            }
        }
        this.deploy(definition);
    }

    @Override
    public void deploy(Composite composite) throws DeploymentException {
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(ContributionResolver.getContribution(), this.getClass().getClassLoader());
        for (ComponentDefinition definition : composite.getComponents().values()) {
            this.componentProcessor.process(definition, (IntrospectionContext)context);
        }
        this.checkErrors(context);
        this.setContributionUris(composite);
        try {
            this.addCompositeToContribution(composite);
            this.domain.include(composite, false);
        }
        catch (org.fabric3.api.host.domain.DeploymentException e) {
            throw new DeploymentException(e);
        }
    }

    @Override
    public void deploy(ComponentDefinition<?> definition) throws DeploymentException {
        URI uri = ContributionResolver.getContribution();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(uri, this.getClass().getClassLoader());
        definition.setContributionUri(uri);
        this.componentProcessor.process(definition, (IntrospectionContext)context);
        this.checkErrors(context);
        try {
            Composite wrapper = this.createWrapperComposite(definition.getName());
            wrapper.add(definition);
            this.domain.include(wrapper, false);
        }
        catch (org.fabric3.api.host.domain.DeploymentException e) {
            throw new DeploymentException(e);
        }
    }

    @Override
    public void deploy(ChannelDefinition definition) throws DeploymentException {
        try {
            URI uri = ContributionResolver.getContribution();
            definition.setContributionUri(uri);
            Composite wrapper = this.createWrapperComposite(definition.getName());
            wrapper.add(definition);
            this.domain.include(wrapper, false);
        }
        catch (org.fabric3.api.host.domain.DeploymentException e) {
            throw new DeploymentException(e);
        }
    }

    @Override
    public void undeploy(QName name) throws DeploymentException {
        try {
            QNameSymbol symbol = new QNameSymbol(name);
            ResourceElement element = this.metaDataStore.find(Composite.class, (Symbol)symbol);
            if (element == null) {
                throw new DeploymentException("Component not deployed: " + name);
            }
            Composite composite = (Composite)element.getValue();
            this.domain.undeploy(composite, false);
            Resource resource = element.getResource();
            Contribution contribution = resource.getContribution();
            contribution.getResources().remove(resource);
        }
        catch (org.fabric3.api.host.domain.DeploymentException e) {
            throw new DeploymentException(e);
        }
    }

    @Override
    public void undeploy(String name) throws DeploymentException {
        QName compositeName = new QName("urn:fabric3.org:synthesized", name);
        this.undeploy(compositeName);
    }

    private Composite createWrapperComposite(String name) {
        QName compositeName = new QName("urn:fabric3.org:synthesized", name);
        Composite wrapper = new Composite(compositeName);
        URI uri = ContributionResolver.getContribution();
        wrapper.setContributionUri(uri);
        this.addCompositeToContribution(wrapper);
        return wrapper;
    }

    private void addCompositeToContribution(Composite wrapper) {
        QName compositeName = wrapper.getName();
        URI uri = ContributionResolver.getContribution();
        Contribution contribution = this.metaDataStore.find(uri);
        Resource resource = new Resource(contribution, null, "text/vnd.fabric3.composite+xml");
        QNameSymbol symbol = new QNameSymbol(compositeName);
        ResourceElement element = new ResourceElement((Symbol)symbol, (Object)wrapper);
        resource.addResourceElement(element);
        resource.setState(ResourceState.PROCESSED);
        contribution.addResource(resource);
    }

    private void addService(Class<?> interfaze, ComponentDefinition<?> definition) throws ValidationDeploymentException {
        URI uri = ContributionResolver.getContribution();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(uri, this.getClass().getClassLoader());
        JavaServiceContract contract = this.contractProcessor.introspect(interfaze, (IntrospectionContext)context, new ModelObject[0]);
        ServiceDefinition serviceDefinition = new ServiceDefinition(interfaze.getSimpleName(), (ServiceContract)contract);
        definition.getComponentType().add(serviceDefinition);
        this.checkErrors(context);
    }

    private void checkErrors(DefaultIntrospectionContext context) throws ValidationDeploymentException {
        List errors = context.getErrors();
        List warnings = context.getErrors();
        if (context.hasErrors()) {
            throw new ValidationDeploymentException(errors, warnings);
        }
    }

    private void setContributionUris(Composite composite) {
        URI uri = ContributionResolver.getContribution();
        composite.setContributionUri(uri);
        for (ComponentDefinition definition : composite.getComponents().values()) {
            definition.setContributionUri(uri);
            if (!(definition.getComponentType() instanceof Composite)) continue;
            this.setContributionUris((Composite)definition.getComponentType());
        }
        for (ComponentDefinition definition : composite.getChannels().values()) {
            definition.setContributionUri(uri);
        }
    }
}

