/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node.domain;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.fabric3.api.host.contribution.ContributionNotFoundException;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.RemoveException;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.contribution.UninstallException;
import org.fabric3.api.host.contribution.UrlContributionSource;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.model.type.component.ChannelDefinition;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.node.domain.ChannelResolver;
import org.fabric3.node.domain.DeploymentException;
import org.fabric3.node.domain.Provisioner;
import org.fabric3.node.domain.ResolverException;
import org.fabric3.node.domain.ServiceResolver;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.annotation.Reference;

public class NodeDomain
implements org.fabric3.api.node.Domain {
    private Provisioner provisioner;
    private ServiceResolver serviceResolver;
    private ChannelResolver channelResolver;
    private ContributionService contributionService;
    private Domain domain;

    public NodeDomain(@Reference Provisioner provisioner, @Reference ServiceResolver serviceResolver, @Reference ChannelResolver channelResolver, @Reference ContributionService contributionService, @Reference(name="domain") Domain domain) {
        this.provisioner = provisioner;
        this.serviceResolver = serviceResolver;
        this.channelResolver = channelResolver;
        this.contributionService = contributionService;
        this.domain = domain;
    }

    public <T> T getService(Class<T> interfaze) {
        try {
            return this.serviceResolver.resolve(interfaze);
        }
        catch (ResolverException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public <T> T getChannel(Class<T> interfaze, String name) {
        try {
            return this.channelResolver.resolve(interfaze, name);
        }
        catch (ResolverException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public org.fabric3.api.node.Domain deploy(Composite composite) {
        try {
            this.provisioner.deploy(composite);
            return this;
        }
        catch (DeploymentException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public org.fabric3.api.node.Domain deploy(String name, Object instance, Class<?> ... interfaces) {
        try {
            this.provisioner.deploy(name, instance, interfaces);
            return this;
        }
        catch (DeploymentException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public org.fabric3.api.node.Domain deploy(ComponentDefinition<?> definition) {
        try {
            this.provisioner.deploy(definition);
            return this;
        }
        catch (DeploymentException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public org.fabric3.api.node.Domain undeploy(QName name) {
        try {
            this.provisioner.undeploy(name);
            return this;
        }
        catch (DeploymentException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public org.fabric3.api.node.Domain undeploy(String name) {
        try {
            this.provisioner.undeploy(name);
            return this;
        }
        catch (DeploymentException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public org.fabric3.api.node.Domain deploy(URL url) {
        try {
            URI uri = url.toURI();
            UrlContributionSource source = new UrlContributionSource(uri, url, false);
            this.contributionService.store((ContributionSource)source);
            this.contributionService.install(uri);
            this.domain.include(Collections.singletonList(uri));
            return this;
        }
        catch (URISyntaxException | ContributionNotFoundException | InstallException | StoreException | org.fabric3.api.host.domain.DeploymentException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public org.fabric3.api.node.Domain undeploy(URL url) {
        try {
            URI uri = url.toURI();
            this.domain.undeploy(uri, true);
            this.contributionService.uninstall(uri);
            this.contributionService.remove(uri);
            return this;
        }
        catch (URISyntaxException | ContributionNotFoundException | RemoveException | UninstallException | org.fabric3.api.host.domain.DeploymentException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public org.fabric3.api.node.Domain deploy(ChannelDefinition definition) {
        try {
            this.provisioner.deploy(definition);
            return this;
        }
        catch (DeploymentException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }
}

