/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node.domain;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.ProducerDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.node.NotFoundException;
import org.fabric3.node.domain.ChannelResolver;
import org.fabric3.node.domain.ContributionResolver;
import org.fabric3.node.domain.InterfaceException;
import org.fabric3.node.domain.Introspector;
import org.fabric3.node.domain.ResolverException;
import org.fabric3.node.nonmanaged.NonManagedImplementation;
import org.fabric3.node.nonmanaged.NonManagedPhysicalConnectionSourceDefinition;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.ChannelConnector;
import org.fabric3.spi.container.builder.channel.ChannelBuilderRegistry;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.channel.ChannelDirection;
import org.fabric3.spi.domain.generator.channel.ChannelGenerator;
import org.fabric3.spi.domain.generator.channel.ConnectionGenerator;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.ChannelDeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class ChannelResolverImpl
implements ChannelResolver {
    private static final QName SYNTHETIC_DEPLOYABLE = new QName("urn:fabric3.org:synthesized", "SyntheticDeployable");
    private Introspector introspector;
    private LogicalComponentManager lcm;
    private ChannelGenerator channelGenerator;
    private ConnectionGenerator connectionGenerator;
    private ChannelBuilderRegistry channelBuilderRegistry;
    private ChannelConnector channelConnector;

    public ChannelResolverImpl(@Reference Introspector introspector, @Reference(name="lcm") LogicalComponentManager lcm, @Reference ChannelGenerator channelGenerator, @Reference ConnectionGenerator connectionGenerator, @Reference ChannelBuilderRegistry channelBuilderRegistry, @Reference ChannelConnector channelConnector) {
        this.introspector = introspector;
        this.lcm = lcm;
        this.channelGenerator = channelGenerator;
        this.connectionGenerator = connectionGenerator;
        this.channelBuilderRegistry = channelBuilderRegistry;
        this.channelConnector = channelConnector;
    }

    @Override
    public <T> T resolve(Class<T> interfaze, String name) throws ResolverException {
        try {
            LogicalChannel logicalChannel = this.getChannel(name);
            LogicalProducer producer = this.createProducer(interfaze, logicalChannel.getUri());
            PhysicalChannelDefinition channelDefinition = this.channelGenerator.generateChannelDefinition(logicalChannel, SYNTHETIC_DEPLOYABLE, ChannelDirection.PRODUCER);
            this.channelBuilderRegistry.build(channelDefinition);
            Map<LogicalChannel, ChannelDeliveryType> channels = Collections.singletonMap(logicalChannel, ChannelDeliveryType.DEFAULT);
            List physicalDefinitions = this.connectionGenerator.generateProducer(producer, channels);
            for (PhysicalChannelConnectionDefinition physicalDefinition : physicalDefinitions) {
                this.channelConnector.connect(physicalDefinition);
            }
            for (PhysicalChannelConnectionDefinition physicalDefinition : physicalDefinitions) {
                PhysicalConnectionSourceDefinition source = physicalDefinition.getSource();
                if (!(source instanceof NonManagedPhysicalConnectionSourceDefinition)) continue;
                NonManagedPhysicalConnectionSourceDefinition sourceDefinition = (NonManagedPhysicalConnectionSourceDefinition)source;
                return interfaze.cast(sourceDefinition.getProxy());
            }
            throw new GenerationException("Source generator not found");
        }
        catch (ContainerException | GenerationException e) {
            throw new ResolverException(e);
        }
    }

    private LogicalChannel getChannel(String name) throws ResolverException {
        String domainRoot;
        URI channelUri;
        LogicalCompositeComponent domainComponent = this.lcm.getRootComponent();
        LogicalChannel logicalChannel = domainComponent.getChannel(channelUri = URI.create((domainRoot = domainComponent.getUri().toString()) + "/" + name));
        if (logicalChannel == null) {
            throw new NotFoundException("Channel not found: " + name);
        }
        return logicalChannel;
    }

    private <T> LogicalProducer createProducer(Class<T> interfaze, URI channelUri) throws InterfaceException {
        JavaServiceContract contract = this.introspector.introspect(interfaze);
        LogicalCompositeComponent domainComponent = this.lcm.getRootComponent();
        String domainRoot = domainComponent.getUri().toString();
        URI componentUri = URI.create(domainRoot + "/F3Synthetic");
        InjectingComponentType componentType = new InjectingComponentType();
        NonManagedImplementation implementation = new NonManagedImplementation();
        implementation.setComponentType((ComponentType)componentType);
        ComponentDefinition componentDefinition = new ComponentDefinition("F3Synthetic");
        componentDefinition.setContributionUri(ContributionResolver.getContribution(interfaze));
        componentDefinition.setImplementation((Implementation)implementation);
        LogicalComponent logicalComponent = new LogicalComponent(componentUri, componentDefinition, domainComponent);
        ProducerDefinition producerDefinition = new ProducerDefinition("producer", (ServiceContract)contract);
        LogicalProducer producer = new LogicalProducer(URI.create(domainRoot + "/F3Synthetic#producer"), producerDefinition, logicalComponent);
        producer.addTarget(channelUri);
        return producer;
    }
}

