/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.recovery.domain;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.domain.DomainJournal;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.recovery.domain.FSDomainReplayMonitor;
import org.fabric3.spi.runtime.event.DomainRecover;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FSDomainReplayer
implements Fabric3EventListener<DomainRecover> {
    private static final QName CONTRIBUTION = new QName("urn:fabric3.org", "contribution");
    private EventService eventService;
    private FSDomainReplayMonitor monitor;
    private XMLInputFactory inputFactory;
    private File domainLog;
    private Domain domain;

    public FSDomainReplayer(@Reference(name="domain") Domain domain, @Reference XMLFactory xmlFactory, @Reference HostInfo hostInfo, @Reference EventService eventService, @Monitor FSDomainReplayMonitor monitor) {
        this.domain = domain;
        this.eventService = eventService;
        this.monitor = monitor;
        this.inputFactory = xmlFactory.newInputFactoryInstance();
        this.domainLog = new File(hostInfo.getDataDir(), "domain.xml");
    }

    @Init
    public void init() {
        this.eventService.subscribe(DomainRecover.class, (Fabric3EventListener)this);
    }

    public void onEvent(DomainRecover event) {
        if (!this.domainLog.exists()) {
            return;
        }
        try {
            DomainJournal journal = this.parse();
            this.domain.recover(journal);
        }
        catch (FileNotFoundException | XMLStreamException | DeploymentException e) {
            this.monitor.error(e);
        }
    }

    private DomainJournal parse() throws FileNotFoundException, XMLStreamException {
        FileInputStream fis = new FileInputStream(this.domainLog);
        BufferedInputStream stream = new BufferedInputStream(fis);
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(stream);
        ArrayList<URI> contributions = new ArrayList<URI>();
        try {
            block12: while (true) {
                switch (reader.next()) {
                    case 1: {
                        if (!CONTRIBUTION.equals(reader.getName())) break;
                        String uri = reader.getAttributeValue(null, "uri");
                        if (uri == null) {
                            Location location = reader.getLocation();
                            int line = location.getLineNumber();
                            int col = location.getColumnNumber();
                            this.monitor.errorMessage("URI attribute missing in domain journal [" + line + "," + col + "]");
                            continue block12;
                        }
                        contributions.add(URI.create(uri));
                        break;
                    }
                    case 8: {
                        DomainJournal domainJournal = new DomainJournal(contributions);
                        return domainJournal;
                    }
                }
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }
}

