/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.databinding.jaxb.factory.JAXBContextFactory;
import org.fabric3.databinding.jaxb.transform.MultiValueArrayTransformer;
import org.fabric3.databinding.jaxb.transform.Node2JAXBElementTransformer;
import org.fabric3.databinding.jaxb.transform.Node2JAXBTransformer;
import org.fabric3.databinding.jaxb.transform.PropertyValue2JAXBTransformer;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerFactory;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Node;

public class Node2JAXBTransformerFactory
implements TransformerFactory {
    private JAXBContextFactory contextFactory;

    public Node2JAXBTransformerFactory(@Reference JAXBContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public int getOrder() {
        return 0;
    }

    public boolean canTransform(DataType source, DataType target) {
        return Node.class.isAssignableFrom(source.getType()) && target instanceof JavaType;
    }

    public Transformer<?, ?> create(DataType source, DataType target, List<Class<?>> sourceTypes, List<Class<?>> targetTypes) throws TransformationException {
        try {
            HashSet types = new HashSet(sourceTypes);
            types.addAll(targetTypes);
            JAXBContext jaxbContext = this.contextFactory.createJAXBContext(types.toArray(new Class[types.size()]));
            if (targetTypes.size() == 1) {
                Class<?> type = targetTypes.iterator().next();
                return this.createTransformer(source, type, jaxbContext);
            }
            if (targetTypes.size() > 1) {
                Transformer[] transformers = new Transformer[sourceTypes.size()];
                for (int i = 0; i < sourceTypes.size(); ++i) {
                    Class<?> type = sourceTypes.get(i);
                    transformers[i] = this.createTransformer(source, type, jaxbContext);
                }
                return new MultiValueArrayTransformer(transformers);
            }
            throw new UnsupportedOperationException("Null parameter operations not yet supported");
        }
        catch (JAXBException e) {
            throw new TransformationException((Throwable)e);
        }
    }

    private Transformer<Node, Object> createTransformer(DataType source, Class<?> type, JAXBContext jaxbContext) {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            if (XSDConstants.PROPERTY_TYPE.equals((Object)source)) {
                return new PropertyValue2JAXBTransformer(jaxbContext);
            }
            return new Node2JAXBTransformer(jaxbContext);
        }
        return new Node2JAXBElementTransformer(jaxbContext, type);
    }
}

