/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.databinding.jaxb.factory.JAXBContextFactory;
import org.fabric3.databinding.jaxb.mapper.JAXBQNameMapper;
import org.fabric3.databinding.jaxb.transform.JAXBElement2StringTransformer;
import org.fabric3.databinding.jaxb.transform.JAXBObject2StringTransformer;
import org.fabric3.databinding.jaxb.transform.MultiValueArrayTransformer;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDType;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerFactory;
import org.oasisopen.sca.annotation.Reference;

public class JAXB2StringTransformerFactory
implements TransformerFactory {
    private JAXBContextFactory contextFactory;
    private JAXBQNameMapper mapper;

    public JAXB2StringTransformerFactory(@Reference JAXBContextFactory contextFactory, @Reference JAXBQNameMapper mapper) {
        this.contextFactory = contextFactory;
        this.mapper = mapper;
    }

    public int getOrder() {
        return 0;
    }

    public boolean canTransform(DataType source, DataType target) {
        return target.getType().equals(String.class) && target instanceof XSDType && source instanceof JavaType;
    }

    public Transformer<?, ?> create(DataType source, DataType target, List<Class<?>> sourceTypes, List<Class<?>> targetTypes) throws TransformationException {
        try {
            HashSet types = new HashSet(sourceTypes);
            types.addAll(targetTypes);
            JAXBContext jaxbContext = this.contextFactory.createJAXBContext(types.toArray(new Class[types.size()]));
            if (sourceTypes.size() == 1) {
                Class<?> type = sourceTypes.iterator().next();
                return this.createTransformer(type, jaxbContext);
            }
            if (sourceTypes.size() > 1) {
                Transformer[] transformers = new Transformer[sourceTypes.size()];
                for (int i = 0; i < sourceTypes.size(); ++i) {
                    Class<?> type = sourceTypes.get(i);
                    transformers[i] = this.createTransformer(type, jaxbContext);
                }
                return new MultiValueArrayTransformer(transformers);
            }
            return this.createTransformer(source.getType(), jaxbContext);
        }
        catch (JAXBException e) {
            throw new TransformationException((Throwable)e);
        }
    }

    private Transformer<Object, String> createTransformer(Class<?> type, JAXBContext jaxbContext) {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return new JAXBObject2StringTransformer(jaxbContext);
        }
        QName name = this.mapper.deriveQName(type);
        return new JAXBElement2StringTransformer(jaxbContext, name);
    }
}

