/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.type.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.api.model.type.java.Signature;

public class MethodInjectionSite
extends InjectionSite
implements Externalizable {
    private static final long serialVersionUID = -2222837362065034249L;
    private Signature signature;
    private int param;
    private transient Method method;

    public MethodInjectionSite(Method method, int param) {
        super(method.getParameterTypes()[param].getName());
        this.signature = new Signature(method);
        this.param = param;
        this.method = method;
    }

    public MethodInjectionSite() {
    }

    public Signature getSignature() {
        return this.signature;
    }

    public int getParam() {
        return this.param;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.signature.toString() + '[' + this.param + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInjectionSite that = (MethodInjectionSite)o;
        return this.signature.equals((Object)that.signature) && this.param == that.param;
    }

    public int hashCode() {
        return this.signature.hashCode() * 31 + this.param;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.signature);
        out.writeInt(this.param);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.signature = (Signature)in.readObject();
        this.param = in.readInt();
    }
}

