/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.type.java;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.Signature;

public class JavaServiceContract
extends ServiceContract {
    private static final long serialVersionUID = -7360275776965712638L;
    private String interfaceClass;
    private List<String> interfaces;
    private String superType;
    private List<Signature> methodSignatures;

    public JavaServiceContract() {
    }

    public JavaServiceContract(Class<?> interfaceClass) {
        this.introspectInterface(interfaceClass);
    }

    public String getQualifiedInterfaceName() {
        return this.getInterfaceClass();
    }

    public String getInterfaceClass() {
        return this.interfaceClass;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public String getSuperType() {
        return this.superType;
    }

    public List<Signature> getMethodSignatures() {
        return this.methodSignatures;
    }

    private void introspectInterface(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass.getName();
        this.methodSignatures = new ArrayList<Signature>();
        Class<?> superClass = interfaceClass.getSuperclass();
        if (superClass != null) {
            this.superType = superClass.getName();
        }
        this.interfaces = new ArrayList<String>();
        for (Method method : interfaceClass.getDeclaredMethods()) {
            Signature signature = new Signature(method);
            if (this.methodSignatures.contains(signature)) continue;
            this.methodSignatures.add(signature);
        }
        this.addInterfaces(interfaceClass, this.interfaces);
    }

    private void addInterfaces(Class<?> interfaze, List<String> interfaces) {
        for (Class<?> superInterface : interfaze.getInterfaces()) {
            if (interfaces.contains(superInterface.getName())) continue;
            interfaces.add(superInterface.getName());
            this.addInterfaces(superInterface, interfaces);
        }
    }
}

