/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.type.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.api.model.type.java.Signature;

public class ConstructorInjectionSite
extends InjectionSite
implements Externalizable {
    private static final long serialVersionUID = -6543986170145816234L;
    private Signature signature;
    private int param;
    private transient Constructor constructor;

    public ConstructorInjectionSite(Constructor<?> constructor, int param) {
        super(constructor.getParameterTypes()[param].getName());
        this.signature = new Signature(constructor);
        this.param = param;
        this.constructor = constructor;
    }

    public ConstructorInjectionSite(Signature signature, int param) {
        super((String)signature.getParameterTypes().get(param));
        this.signature = signature;
        this.param = param;
    }

    public ConstructorInjectionSite() {
    }

    public Signature getSignature() {
        return this.signature;
    }

    public int getParam() {
        return this.param;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public String toString() {
        return this.signature.toString() + '[' + this.param + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorInjectionSite that = (ConstructorInjectionSite)o;
        return this.param == that.param && this.signature.equals((Object)that.signature);
    }

    public int hashCode() {
        return 31 * this.signature.hashCode() + this.param;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.signature);
        out.writeInt(this.param);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.signature = (Signature)in.readObject();
        this.param = in.readInt();
    }
}

