/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.physical;

import java.io.Serializable;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;

public class PhysicalWireDefinition
implements Serializable {
    private static final long serialVersionUID = 995196092611674935L;
    private PhysicalWireSourceDefinition source;
    private PhysicalWireTargetDefinition target;
    private QName sourceDeployable;
    private QName targetDeployable;
    private final Set<PhysicalOperationDefinition> operations;
    private boolean optimizable;

    public PhysicalWireDefinition(PhysicalWireSourceDefinition source, PhysicalWireTargetDefinition target, Set<PhysicalOperationDefinition> operations) {
        this.source = source;
        this.target = target;
        this.operations = operations;
    }

    public PhysicalWireDefinition(PhysicalWireSourceDefinition source, QName sourceDeployable, PhysicalWireTargetDefinition target, QName targetDeployable, Set<PhysicalOperationDefinition> operations) {
        this.source = source;
        this.sourceDeployable = sourceDeployable;
        this.target = target;
        this.operations = operations;
        this.targetDeployable = targetDeployable;
    }

    public QName getSourceDeployable() {
        return this.sourceDeployable;
    }

    public QName getTargetDeployable() {
        return this.targetDeployable;
    }

    public boolean isOptimizable() {
        return this.optimizable;
    }

    public void setOptimizable(boolean optimizable) {
        this.optimizable = optimizable;
    }

    public void addOperation(PhysicalOperationDefinition operation) {
        this.operations.add(operation);
    }

    public Set<PhysicalOperationDefinition> getOperations() {
        return this.operations;
    }

    public PhysicalWireSourceDefinition getSource() {
        return this.source;
    }

    public PhysicalWireTargetDefinition getTarget() {
        return this.target;
    }
}

