/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.physical;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fabric3.spi.model.os.Library;
import org.fabric3.spi.model.physical.PhysicalClassLoaderWireDefinition;

public class PhysicalClassLoaderDefinition
implements Serializable {
    private static final long serialVersionUID = 1869864181383360066L;
    private URI uri;
    private boolean provisionArtifact;
    private Set<PhysicalClassLoaderWireDefinition> wireDefinitions = new LinkedHashSet<PhysicalClassLoaderWireDefinition>();
    private List<Library> libraries = Collections.emptyList();

    public PhysicalClassLoaderDefinition(URI uri, boolean provisionArtifact) {
        this.uri = uri;
        this.provisionArtifact = provisionArtifact;
    }

    public PhysicalClassLoaderDefinition(URI uri, List<Library> libraries, boolean provisionArtifact) {
        this.uri = uri;
        this.libraries = libraries;
        this.provisionArtifact = provisionArtifact;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isProvisionArtifact() {
        return this.provisionArtifact;
    }

    public void add(PhysicalClassLoaderWireDefinition definition) {
        this.wireDefinitions.add(definition);
    }

    public Set<PhysicalClassLoaderWireDefinition> getWireDefinitions() {
        return this.wireDefinitions;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalClassLoaderDefinition that = (PhysicalClassLoaderDefinition)o;
        return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri)) && !(this.wireDefinitions == null ? that.wireDefinitions != null : !this.wireDefinitions.equals(that.wireDefinitions));
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.wireDefinitions != null ? this.wireDefinitions.hashCode() : 0);
        return result;
    }
}

