/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.os;

import org.fabric3.api.host.Version;
import org.fabric3.api.host.os.OperatingSystem;
import org.fabric3.spi.model.version.Versionable;

public class OperatingSystemSpec
extends Versionable {
    private static final long serialVersionUID = 464100854160609807L;
    private String name;
    private String processor;

    public OperatingSystemSpec(String name, String processor) {
        this.name = name;
        this.processor = processor;
    }

    public OperatingSystemSpec(String name, String processor, Version minVersion, boolean minInclusive) {
        super(minVersion, minInclusive);
        this.name = name;
        this.processor = processor;
    }

    public OperatingSystemSpec(String name, String processor, Version minVersion, boolean minInclusive, Version maxVersion, boolean maxInclusive) {
        super(minVersion, minInclusive, maxVersion, maxInclusive);
        this.name = name;
        this.processor = processor;
    }

    public String getName() {
        return this.name;
    }

    public String getProcessor() {
        return this.processor;
    }

    public boolean matches(OperatingSystemSpec other) {
        return super.matches(other.getMinVersion()) && this.name.equals(other.getName()) && (this.processor == null && other.getProcessor() == null || this.processor.equals(other.getProcessor()));
    }

    public boolean matches(OperatingSystem os) {
        if ((this.name.equals(os.getName()) || this.name.equalsIgnoreCase("windows") && os.getName().startsWith("Windows")) && (this.processor == null || this.processor.equalsIgnoreCase(os.getProcessor()))) {
            return super.matches(os.getVersion());
        }
        return false;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.processor != null ? this.processor.hashCode() : 0);
        result = 31 * result + (this.minVersion != null ? this.minVersion.hashCode() : 0);
        result = 31 * result + (this.maxVersion != null ? this.maxVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("operating system: " + this.name);
        if (this.processor != null) {
            builder.append("processor: ").append(this.processor);
        }
        if (this.minVersion != null) {
            builder.append(" Min: ").append(this.minVersion);
        }
        if (this.maxVersion != null) {
            builder.append(" Max: ").append(this.maxVersion);
        }
        return builder.toString();
    }
}

