/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.component.ProducerDefinition;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalOperation;

public class LogicalProducer
extends LogicalInvocable {
    private static final long serialVersionUID = 5403855901902189810L;
    private ProducerDefinition definition;
    private List<URI> targets;

    public LogicalProducer(URI uri, ProducerDefinition definition, LogicalComponent<?> parent) {
        super(uri, definition != null ? definition.getServiceContract() : null, parent);
        this.definition = definition;
        this.targets = new ArrayList<URI>();
        if (definition != null) {
            this.addIntents(definition.getIntents());
            this.addPolicySets(definition.getPolicySets());
        }
    }

    public ProducerDefinition getDefinition() {
        return this.definition;
    }

    public List<URI> getTargets() {
        return this.targets;
    }

    public void addTarget(URI uri) {
        this.targets.add(uri);
    }

    public void addTargets(List<URI> targets) {
        this.targets.addAll(targets);
    }

    public LogicalOperation getStreamOperation() {
        if (this.operations.size() != 1) {
            throw new IllegalStateException("Invalid number of operations: " + this.operations.size());
        }
        return (LogicalOperation)this.operations.get(0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalProducer test = (LogicalProducer)obj;
        return this.getUri().equals(test.getUri());
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }
}

