/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.component.ConsumerDefinition;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalInvocable;

public class LogicalConsumer
extends LogicalInvocable {
    private static final long serialVersionUID = -8094856609591381761L;
    private ConsumerDefinition definition;
    private List<URI> sources;

    public LogicalConsumer(URI uri, ConsumerDefinition definition, LogicalComponent<?> parent) {
        super(uri, null, parent);
        this.definition = definition;
        this.sources = new ArrayList<URI>();
        if (definition != null) {
            this.addIntents(definition.getIntents());
            this.addPolicySets(definition.getPolicySets());
        }
    }

    public ConsumerDefinition getDefinition() {
        return this.definition;
    }

    public List<URI> getSources() {
        return this.sources;
    }

    public void addSources(List<URI> sources) {
        this.sources.addAll(sources);
    }

    public void addSource(URI uri) {
        this.sources.add(uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalConsumer test = (LogicalConsumer)obj;
        return this.getUri().equals(test.getUri());
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }
}

