/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.CompositeImplementation;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;

public class LogicalCompositeComponent
extends LogicalComponent<CompositeImplementation> {
    private static final long serialVersionUID = 6661201121307925462L;
    private Map<LogicalReference, List<LogicalWire>> wires = new HashMap<LogicalReference, List<LogicalWire>>();
    private Map<URI, LogicalComponent<?>> components = new HashMap();
    private Map<URI, LogicalChannel> channels = new HashMap<URI, LogicalChannel>();
    private List<LogicalResource<?>> resources = new ArrayList();

    public LogicalCompositeComponent(URI uri, ComponentDefinition<CompositeImplementation> definition, LogicalCompositeComponent parent) {
        super(uri, definition, parent);
    }

    public void addWire(LogicalReference logicalReference, LogicalWire logicalWire) {
        List<LogicalWire> logicalWires = this.wires.get(logicalReference);
        if (logicalWires == null) {
            logicalWires = new ArrayList<LogicalWire>();
            this.wires.put(logicalReference, logicalWires);
        }
        logicalWires.add(logicalWire);
    }

    public void addWires(LogicalReference logicalReference, List<LogicalWire> newWires) {
        List<LogicalWire> logicalWires = this.wires.get(logicalReference);
        if (logicalWires == null) {
            logicalWires = new ArrayList<LogicalWire>();
            this.wires.put(logicalReference, logicalWires);
        }
        logicalWires.addAll(newWires);
    }

    public void overrideWires(LogicalReference logicalReference, List<LogicalWire> logicalWires) {
        this.wires.put(logicalReference, logicalWires);
    }

    public List<LogicalWire> getWires(LogicalReference logicalReference) {
        List<LogicalWire> logicalWires = this.wires.get(logicalReference);
        if (logicalWires == null) {
            return Collections.emptyList();
        }
        return logicalWires;
    }

    public Map<LogicalReference, List<LogicalWire>> getWires() {
        return this.wires;
    }

    public Collection<LogicalComponent<?>> getComponents() {
        return this.components.values();
    }

    public LogicalComponent<?> getComponent(URI uri) {
        return this.components.get(uri);
    }

    public void removeComponent(URI uri) {
        this.components.remove(uri);
    }

    public void addComponent(LogicalComponent<?> component) {
        this.components.put(component.getUri(), component);
    }

    public Collection<LogicalChannel> getChannels() {
        return this.channels.values();
    }

    public LogicalChannel getChannel(URI uri) {
        return this.channels.get(uri);
    }

    public void removeChannel(URI uri) {
        this.channels.remove(uri);
    }

    public void addChannel(LogicalChannel channel) {
        this.channels.put(channel.getUri(), channel);
    }

    public Collection<LogicalResource<?>> getResources() {
        return this.resources;
    }

    @Override
    public void addResource(LogicalResource<?> resource) {
        this.resources.add(resource);
    }

    @Override
    public void setState(LogicalState state) {
        super.setState(state);
        for (LogicalComponent<?> component : this.getComponents()) {
            component.setState(state);
        }
    }
}

