/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.ChannelDefinition;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.type.binding.SCABinding;

public class LogicalChannel
extends Bindable {
    private static final long serialVersionUID = -1098943196013754799L;
    private ChannelDefinition definition;
    private String zone = "LocalZone";
    private QName deployable;
    private LogicalState state = LogicalState.NEW;

    public LogicalChannel(URI uri, ChannelDefinition definition, LogicalCompositeComponent parent) {
        super(uri, null, parent);
        this.definition = definition;
    }

    public ChannelDefinition getDefinition() {
        return this.definition;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public void setDeployable(QName deployable) {
        this.deployable = deployable;
    }

    public LogicalState getState() {
        return this.state;
    }

    public void setState(LogicalState state) {
        this.state = state;
    }

    public LogicalBinding getBinding() {
        if (this.getBindings().isEmpty()) {
            return null;
        }
        return this.getBindings().get(0);
    }

    public void clearBinding() {
        this.getBindings().clear();
    }

    public boolean isBound() {
        if (this.getBindings().isEmpty()) {
            return false;
        }
        for (LogicalBinding<?> binding : this.getBindings()) {
            if (binding.getDefinition() instanceof SCABinding) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addBinding(LogicalBinding<?> binding) {
        if (!this.getBindings().isEmpty()) {
            throw new IllegalStateException("Channel is already configured with a binding");
        }
        super.addBinding(binding);
    }
}

