/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.Location;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;

public abstract class XmlValidationFailure
extends ValidationFailure {
    private int line = -1;
    private int column = -1;
    private int offset = -1;
    private String resourceURI = "system";
    private String message;
    private List<Object> sources;

    protected XmlValidationFailure(String message, Location location, ModelObject ... sources) {
        this.message = message;
        if (location != null) {
            this.line = location.getLineNumber();
            this.column = location.getColumnNumber();
            this.offset = location.getCharacterOffset();
            this.resourceURI = location.getSystemId();
        }
        this.sources = new ArrayList<Object>();
        if (sources != null) {
            this.sources.addAll(Arrays.asList(sources));
        }
    }

    protected XmlValidationFailure(String message) {
        this(message, null, new ModelObject[0]);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.message);
        if (this.line != -1) {
            builder.append(" [").append(this.line).append(',').append(this.column).append("]");
        }
        return builder.toString();
    }

    public String getShortMessage() {
        return this.message;
    }
}

