/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.spi.introspection.xml.DeprecatedNamespaceHelper;
import org.fabric3.spi.introspection.xml.XmlValidationFailure;

public class UnrecognizedElement
extends XmlValidationFailure {
    private QName name;

    public UnrecognizedElement(XMLStreamReader reader, Location location, ModelObject ... sources) {
        super("Unrecognized element", location, sources);
        this.name = reader.getName();
    }

    @Override
    public String getMessage() {
        String namespace = this.name.getNamespaceURI();
        if (DeprecatedNamespaceHelper.isDeprecatedNamespace(namespace)) {
            if (this.getLine() == -1) {
                return "The element specified in " + this.getResourceURI() + " uses the deprecated namespace " + namespace + ". Please change it to " + "urn:fabric3.org";
            }
            return "The element specified in " + this.getResourceURI() + " at " + this.getLine() + "," + this.getColumn() + " uses the deprecated namespace " + namespace + ". Please change it to " + "urn:fabric3.org";
        }
        if (this.getLine() == -1) {
            return "The element " + this.name + " specified in " + this.getResourceURI() + " was not recognized. " + "If this is not a typo, check to ensure extensions are configured properly.";
        }
        return "The element " + this.name + " specified in " + this.getResourceURI() + " at " + this.getLine() + "," + this.getColumn() + " was not recognized. " + "If this is not a typo, check to ensure extensions are configured properly.";
    }

    @Override
    public String getShortMessage() {
        String namespace = this.name.getNamespaceURI();
        if (DeprecatedNamespaceHelper.isDeprecatedNamespace(namespace)) {
            return "The element uses the deprecated namespace " + namespace + ". Please change it to " + "urn:fabric3.org";
        }
        return "The element " + this.name + " was not recognized";
    }
}

