/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.fabric3.api.annotation.model.BindingHandler;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.BindingHandlerDefinition;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.PostProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public abstract class AbstractBindingPostProcessor<A extends Annotation>
implements PostProcessor {
    private Class<A> annotationType;
    private Method serviceAttribute;

    protected AbstractBindingPostProcessor(Class<A> annotationType) {
        this.annotationType = annotationType;
        try {
            this.serviceAttribute = annotationType.getDeclaredMethod("service", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Binding annotation must have a service attribute");
        }
    }

    @Override
    public void process(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        this.processService(componentType, implClass, context);
        this.processReferences(componentType, implClass, context);
    }

    protected String getNullibleValue(String value) {
        return value.isEmpty() ? null : value;
    }

    protected abstract BindingDefinition processService(A var1, AbstractService<?> var2, InjectingComponentType var3, Class<?> var4, IntrospectionContext var5);

    protected abstract BindingDefinition processServiceCallback(A var1, AbstractService<?> var2, InjectingComponentType var3, Class<?> var4, IntrospectionContext var5);

    protected abstract BindingDefinition processReference(A var1, ReferenceDefinition var2, AccessibleObject var3, Class<?> var4, IntrospectionContext var5);

    protected abstract BindingDefinition processReferenceCallback(A var1, ReferenceDefinition var2, AccessibleObject var3, Class<?> var4, IntrospectionContext var5);

    private void processService(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        BindingDefinition callbackBinding;
        A annotation = implClass.getAnnotation(this.annotationType);
        if (annotation == null) {
            return;
        }
        Class<?> serviceInterface = this.getService(annotation);
        if (serviceInterface.equals(Void.class)) {
            serviceInterface = null;
        }
        AbstractService boundService = null;
        if (serviceInterface == null) {
            if (componentType.getServices().size() != 1) {
                InvalidAnnotation error = new InvalidAnnotation("Binding annotation must specify a service interface", implClass, (Annotation)annotation, implClass);
                context.addError(error);
                return;
            }
            boundService = (AbstractService)componentType.getServices().values().iterator().next();
        } else {
            String name = serviceInterface.getName();
            for (AbstractService service : componentType.getServices().values()) {
                String interfaceName = service.getServiceContract().getQualifiedInterfaceName();
                if (!interfaceName.equals(name)) continue;
                boundService = service;
                break;
            }
            if (boundService == null) {
                InvalidAnnotation error = new InvalidAnnotation("Service specified in binding annotation not found: " + name, implClass, (Annotation)annotation, implClass);
                context.addError(error);
                return;
            }
        }
        BindingDefinition binding = this.processService(annotation, boundService, componentType, implClass, context);
        if (binding == null) {
            return;
        }
        this.processHandlers(implClass, binding, implClass, context);
        boundService.addBinding(binding);
        ServiceContract contract = boundService.getServiceContract();
        if (contract.getCallbackContract() != null && (callbackBinding = this.processServiceCallback(annotation, boundService, componentType, implClass, context)) != null) {
            boundService.addCallbackBinding(callbackBinding);
        }
    }

    private void processReferences(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        for (Map.Entry entry : componentType.getInjectionSiteMappings().entrySet()) {
            Annotation[] annotations;
            if (!(entry.getKey() instanceof ReferenceDefinition)) continue;
            ReferenceDefinition reference = (ReferenceDefinition)entry.getKey();
            InjectionSite site = (InjectionSite)entry.getValue();
            if (site instanceof FieldInjectionSite) {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = fieldSite.getField();
                this.processBindingAnnotation(field, reference, implClass, context);
                continue;
            }
            if (site instanceof MethodInjectionSite) {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getMethod();
                this.processBindingAnnotation(method, reference, implClass, context);
                continue;
            }
            if (!(site instanceof ConstructorInjectionSite)) continue;
            ConstructorInjectionSite constructorSite = (ConstructorInjectionSite)site;
            Constructor constructor = constructorSite.getConstructor();
            for (Annotation annotation : annotations = constructor.getParameterAnnotations()[constructorSite.getParam()]) {
                BindingDefinition callbackBinding;
                Annotation castAnnotation;
                BindingDefinition binding;
                if (!this.annotationType.equals(annotation.annotationType()) || (binding = this.processReference(castAnnotation = (Annotation)this.annotationType.cast(annotation), reference, constructor, implClass, context)) == null) continue;
                reference.addBinding(binding);
                ServiceContract contract = reference.getServiceContract();
                if (contract.getCallbackContract() == null || (callbackBinding = this.processReferenceCallback(castAnnotation, reference, constructor, implClass, context)) == null) continue;
                reference.addCallbackBinding(callbackBinding);
            }
        }
    }

    private void processBindingAnnotation(AccessibleObject object, ReferenceDefinition reference, Class<?> implClass, IntrospectionContext context) {
        BindingDefinition callbackBinding;
        A annotation = object.getAnnotation(this.annotationType);
        if (annotation == null) {
            return;
        }
        BindingDefinition binding = this.processReference(annotation, reference, object, implClass, context);
        if (binding == null) {
            return;
        }
        reference.addBinding(binding);
        ServiceContract contract = reference.getServiceContract();
        if (contract.getCallbackContract() != null && (callbackBinding = this.processReferenceCallback((Annotation)this.annotationType.cast(annotation), reference, object, implClass, context)) != null) {
            reference.addCallbackBinding(callbackBinding);
        }
    }

    private void processHandlers(AnnotatedElement element, BindingDefinition binding, Class<?> implClass, IntrospectionContext context) {
        BindingHandler annotation = element.getAnnotation(BindingHandler.class);
        if (annotation == null) {
            return;
        }
        if (annotation.value().isEmpty()) {
            String[] values;
            for (String value : values = annotation.handlers()) {
                this.parseHandlerUri(value, element, binding, implClass, context, annotation);
            }
        } else {
            this.parseHandlerUri(annotation.value(), element, binding, implClass, context, annotation);
        }
    }

    private void parseHandlerUri(String value, AnnotatedElement element, BindingDefinition binding, Class<?> implClass, IntrospectionContext context, BindingHandler annotation) {
        try {
            BindingHandlerDefinition definition = new BindingHandlerDefinition(new URI(value));
            binding.addHandler(definition);
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid binding handler URI", element, (Annotation)annotation, implClass, e);
            context.addError(error);
        }
    }

    private Class<?> getService(A annotation) {
        try {
            return (Class)this.serviceAttribute.invoke(annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

