/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.federation.addressing;

import java.io.Serializable;
import org.fabric3.spi.host.Port;

public class SocketAddress
implements Serializable {
    private static final long serialVersionUID = -6325896048393741909L;
    private String runtimeName;
    private String zone;
    private String protocol;
    private String address;
    private Port port;

    public SocketAddress(String runtimeName, String zone, String protocol, String address, Port port) {
        this.runtimeName = runtimeName;
        this.zone = zone;
        this.protocol = protocol;
        this.address = address;
        this.port = port;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getZone() {
        return this.zone;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAddress() {
        return this.address;
    }

    public Port getPort() {
        return this.port;
    }

    public String toProtocolString() {
        return this.protocol + "://" + this.address + ":" + this.port.getNumber();
    }

    public String toString() {
        return this.protocol + "://" + this.address + ":" + this.port.getNumber() + " [" + this.runtimeName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketAddress that = (SocketAddress)o;
        return !(this.port.getNumber() != that.port.getNumber() || (this.address == null ? that.address != null : !this.address.equals(that.address)) || (this.protocol == null ? that.protocol != null : !this.protocol.equals(that.protocol)) || (this.runtimeName == null ? that.runtimeName != null : !this.runtimeName.equals(that.runtimeName)));
    }

    public int hashCode() {
        int result = this.runtimeName != null ? this.runtimeName.hashCode() : 0;
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + this.port.getNumber();
        return result;
    }
}

