/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.domain.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.spi.container.command.CompensatableCommand;
import org.fabric3.spi.domain.generator.DeploymentUnit;

public class Deployment {
    private String id;
    private Map<String, DeploymentUnit> units = new HashMap<String, DeploymentUnit>();

    public Deployment(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addProvisionCommand(String zone, CompensatableCommand command) {
        DeploymentUnit unit = this.getDeploymentUnit(zone);
        unit.addProvisionCommand(command);
    }

    public void addProvisionCommands(String zone, List<CompensatableCommand> commands) {
        DeploymentUnit unit = this.getDeploymentUnit(zone);
        unit.addProvisionCommands(commands);
    }

    public void addExtensionCommand(String zone, CompensatableCommand command) {
        DeploymentUnit unit = this.getDeploymentUnit(zone);
        unit.addExtensionCommand(command);
    }

    public void addExtensionCommands(String zone, List<CompensatableCommand> commands) {
        DeploymentUnit unit = this.getDeploymentUnit(zone);
        unit.addExtensionCommands(commands);
    }

    public void addCommand(String zone, CompensatableCommand command) {
        DeploymentUnit unit = this.getDeploymentUnit(zone);
        unit.addCommand(command);
    }

    public void addCommands(String zone, List<CompensatableCommand> commands) {
        DeploymentUnit unit = this.getDeploymentUnit(zone);
        unit.addCommands(commands);
    }

    public Set<String> getZones() {
        return this.units.keySet();
    }

    public DeploymentUnit getDeploymentUnit() {
        if (this.units.isEmpty()) {
            DeploymentUnit unit = new DeploymentUnit();
            this.units.put("LocalZone", unit);
            return unit;
        }
        return this.units.values().iterator().next();
    }

    public DeploymentUnit getDeploymentUnit(String zone) {
        DeploymentUnit unit = this.units.get(zone);
        if (unit == null) {
            unit = new DeploymentUnit();
            this.units.put(zone, unit);
        }
        return unit;
    }

    public Map<String, List<CompensatableCommand>> getCommands() {
        HashMap<String, List<CompensatableCommand>> ret = new HashMap<String, List<CompensatableCommand>>();
        for (Map.Entry<String, DeploymentUnit> entry : this.units.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getCommands());
        }
        return ret;
    }
}

