/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution.manifest;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;

public class QNameImport
implements Import {
    private static final long serialVersionUID = 7714960525252585065L;
    private static final QName QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "import");
    private String namespace;
    private URI location;
    private Map<URI, Export> resolved;

    public QNameImport(String namespace, URI location) {
        this.namespace = namespace;
        this.location = location;
        this.resolved = new HashMap<URI, Export>();
    }

    @Override
    public QName getType() {
        return QNAME;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public boolean isMultiplicity() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public Map<URI, Export> getResolved() {
        return this.resolved;
    }

    @Override
    public void addResolved(URI contributionUri, Export export) {
        this.resolved.put(contributionUri, export);
    }

    public String toString() {
        return "qname: " + this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QNameImport that = (QNameImport)o;
        return !(this.location == null ? that.location != null : !this.location.equals(that.location)) && !(this.namespace == null ? that.namespace != null : !this.namespace.equals(that.namespace));
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        return result;
    }
}

