/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.host.stream.Source;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Resource;

public class Contribution
implements Serializable {
    private static final long serialVersionUID = 2511879480122631196L;
    private URI uri;
    private transient Source source;
    private ContributionState state = ContributionState.STORED;
    private List<URI> profiles;
    private URL location;
    private long timestamp;
    private String contentType;
    private boolean persistent;
    private ContributionManifest manifest = new ContributionManifest();
    private transient List<Resource> resources = new ArrayList<Resource>();
    private transient Map<Object, Object> metadata = new HashMap<Object, Object>();
    private List<ContributionWire<?, ?>> wires = new ArrayList();
    private List<URI> resolvedExtensionProviders = new ArrayList<URI>();
    private List<QName> lockOwners = new ArrayList<QName>();
    private List<URL> additionalLocations = new ArrayList<URL>();

    public Contribution(URI uri) {
        this.uri = uri;
        this.profiles = new ArrayList<URI>();
    }

    public Contribution(URI uri, Source source, URL location, long timestamp, String contentType, boolean persistent) {
        this.uri = uri;
        this.source = source;
        this.profiles = new ArrayList<URI>();
        this.location = location;
        this.timestamp = timestamp;
        this.contentType = contentType;
        this.persistent = persistent;
    }

    public URI getUri() {
        return this.uri;
    }

    public ContributionState getState() {
        return this.state;
    }

    public void setState(ContributionState state) {
        this.state = state;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public List<URL> getAdditionalLocations() {
        return this.additionalLocations;
    }

    public void addAdditionalLocation(URL location) {
        this.additionalLocations.add(location);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Source getSource() {
        return this.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ContributionManifest getManifest() {
        return this.manifest;
    }

    public void setManifest(ContributionManifest manifest) {
        this.manifest = manifest;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public List<URI> getProfiles() {
        return this.profiles;
    }

    public void addProfile(URI uri) {
        this.profiles.add(uri);
    }

    public void addProfiles(List<URI> uris) {
        this.profiles.addAll(uris);
    }

    public void removeProfile(URI uri) {
        this.profiles.remove(uri);
    }

    public void addWire(ContributionWire<?, ?> wire) {
        this.wires.add(wire);
    }

    public List<ContributionWire<?, ?>> getWires() {
        return this.wires;
    }

    public void addResolvedExtensionProvider(URI uri) {
        this.resolvedExtensionProviders.add(uri);
    }

    public List<URI> getResolvedExtensionProviders() {
        return this.resolvedExtensionProviders;
    }

    public void addMetaData(Object key, Object value) {
        this.metadata.put(key, value);
    }

    public void removeMetaData(Object key) {
        this.metadata.remove(key);
    }

    public <T> T getMetaData(Class<T> type, Object key) {
        return type.cast(this.metadata.get(key));
    }

    public void acquireLock(QName owner) {
        if (this.lockOwners.contains(owner)) {
            throw new IllegalStateException("Lock already held by owner for contribution " + this.uri + " :" + owner);
        }
        this.lockOwners.add(owner);
    }

    public void releaseLock(QName owner) {
        if (this.lockOwners.isEmpty()) {
            return;
        }
        if (!this.lockOwners.remove(owner)) {
            throw new IllegalStateException("Lock not held by owner for contribution " + this.uri + " :" + owner);
        }
    }

    public List<QName> getLockOwners() {
        return this.lockOwners;
    }

    public boolean isLocked() {
        return !this.lockOwners.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contribution that = (Contribution)o;
        return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri));
    }
}

