/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.container.invocation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.SecuritySubject;
import org.fabric3.spi.container.invocation.CallbackReference;

public class WorkContext
implements Serializable {
    private static final long serialVersionUID = 9108092492339191639L;
    private transient SecuritySubject subject;
    private List<CallbackReference> callStack;
    private transient Map<String, Object> headers;

    public void setSubject(SecuritySubject subject) {
        this.subject = subject;
    }

    public SecuritySubject getSubject() {
        return this.subject;
    }

    public void addCallbackReference(CallbackReference callbackReference) {
        if (this.callStack == null) {
            this.callStack = new ArrayList<CallbackReference>();
        }
        this.callStack.add(callbackReference);
    }

    public void addCallbackReferences(List<CallbackReference> callbackReferences) {
        if (this.callStack == null) {
            this.callStack = callbackReferences;
            return;
        }
        this.callStack.addAll(callbackReferences);
    }

    public CallbackReference popCallbackReference() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.remove(this.callStack.size() - 1);
    }

    public CallbackReference peekCallbackReference() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.get(this.callStack.size() - 1);
    }

    public List<CallbackReference> getCallbackReferences() {
        return this.callStack;
    }

    public <T> T getHeader(Class<T> type, String name) {
        if (this.headers == null) {
            return null;
        }
        return type.cast(this.headers.get(name));
    }

    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        if (this.headers == null) {
            return;
        }
        this.headers.remove(name);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void addHeaders(Map<String, Object> newHeaders) {
        if (this.headers == null) {
            this.headers = newHeaders;
            return;
        }
        this.headers.putAll(newHeaders);
    }

    public void reset() {
        this.subject = null;
        this.headers = null;
        this.callStack = null;
    }
}

