/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.container.invocation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.spi.container.invocation.CallbackReference;

public class CallbackReferenceSerializer {
    public static String serializeToString(List<CallbackReference> references) {
        StringBuilder builder = new StringBuilder();
        for (CallbackReference reference : references) {
            String correlationId = reference.getCorrelationId();
            if (correlationId == null) {
                builder.append(",");
            } else {
                builder.append(correlationId).append(",");
            }
            String callbackUri = reference.getServiceUri();
            builder.append(callbackUri).append(",");
        }
        return builder.toString();
    }

    public static byte[] serializeToBytes(List<CallbackReference> references) throws IOException {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        DataOutputStream das = new DataOutputStream(bas);
        das.writeInt(references.size());
        for (CallbackReference reference : references) {
            String correlationId = reference.getCorrelationId();
            if (correlationId == null) {
                das.writeInt(0);
            } else {
                das.writeInt(correlationId.length());
                das.writeBytes(correlationId);
            }
            String callbackUri = reference.getServiceUri();
            das.writeInt(callbackUri.length());
            das.writeBytes(callbackUri);
        }
        return bas.toByteArray();
    }

    public static List<CallbackReference> deserialize(byte[] bytes) throws IOException {
        int number;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        ArrayList<CallbackReference> references = new ArrayList<CallbackReference>(number);
        for (number = dis.readInt(); number > 0; --number) {
            String correlationId = null;
            int correlationSize = dis.readInt();
            if (correlationSize > 0) {
                byte[] correlationBytes = new byte[correlationSize];
                dis.read(correlationBytes);
                correlationId = new String(correlationBytes);
            }
            String callbackUri = null;
            int callbackUriSize = dis.readInt();
            if (callbackUriSize > 0) {
                byte[] uriBytes = new byte[callbackUriSize];
                dis.read(uriBytes);
                callbackUri = new String(uriBytes);
            }
            references.add(new CallbackReference(callbackUri, correlationId));
        }
        return references;
    }

    public static List<CallbackReference> deserialize(String serialized) {
        ArrayList<CallbackReference> references = new ArrayList<CallbackReference>();
        String[] tokens = serialized.split(",");
        for (int i = 0; i < tokens.length; i += 2) {
            String callbackUri = tokens[i + 1];
            String correlationId = tokens[i].length() == 0 ? null : tokens[i];
            references.add(new CallbackReference(callbackUri, correlationId));
        }
        return references;
    }
}

